#include <mbed.h>
#include <string>
#include <list>

#include <mpr121.h>
#include "SongPlayer.h"
#include "fastlib/clock.h"

SongPlayer mySpeaker(p21);

//fl_select_pll0_clock_source(1);
//fl_pll0_control(1,1); //enable PLL clock
//fl_pll0_config(1, 512); //Configure output clock freq.

Timer       t;
Timer       t_rest;
Timer       t_base;
Timer       reset_timer;
Timer       song_timer;
bool        timer_begin = 0;
bool        played = 0;
uint16_t    value = 0;
float       temp_value;
PwmOut      jawServo(p26);
PwmOut      baseServo(p25);
DigitalIn   record_mode(p14);
DigitalIn   play_back_mode(p16);
DigitalIn   play_live_mode(p15);
DigitalIn   stop_mode(p17);
DigitalIn   reset_mode(p20);
DigitalOut  greenLED(p23);
DigitalOut  redLED(p18);
DigitalOut  blueLED(p22);


enum        Statetype {IDLE = 0, REC = 1, PLAY_BACK = 2, PLAY_LIVE = 3, STOP = 4, RESET = 5};

Statetype   mode;

float       mem_note[160];
float       mem_duration[160];
int         mem_ind;
float       dt;
float dur[1]= {0.5f};

class Watchdog
{
public:
// Load timeout value in watchdog timer and enable
    void kick(float s)
    {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick()
    {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog wdt;

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p30);

// Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

float note = 0;

float parse_key(uint16_t input)
{
    switch(input) {
        case 0x0:
            return 0.0;
        case 0x1:
            return 440.0;
        case 0x2:
            return 446.16;
        case 0x4:
            return 493.88;
        case 0x8:
            return 523.25;
        case 0x10:
            return 554.37;
        case 0x20:
            return 587.33;
        case 0x40:
            return 622.25;
        case 0x80:
            return 659.25;
        case 0x100:
            return 698.46;
        case 0x200:
            return 739.99;
        case 0x400:
            return 783.99;
        case 0x800:
            return 830.61;
        default:
            return 0.0;
    }
}

void dance(uint16_t note_input)
{

    if(note_input == 0x1) {
        redLED = 1;
        greenLED = 0;
        blueLED = 0;
        jawServo.write(0.11f);
        baseServo.write(0.11f);
    } else if(note_input == 0x1) {
        redLED = 1;
        greenLED = 1;
        blueLED = 0;
        jawServo.write(0.18f);
        baseServo.write(0.18f);
    } else if(note_input == 0x2) {
        redLED = 1;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.23f);
        baseServo.write(0.23f);
    } else if(note_input == 0x4) {
        redLED = 0;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.28f);
        baseServo.write(0.28f);
    } else if(note_input == 0x8) {
        redLED = 0;
        greenLED = 0;
        blueLED = 1;
        jawServo.write(0.34f);
        baseServo.write(0.34f);
    } else if(note_input == 0x10) {
        redLED = 0;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.39f);
        baseServo.write(0.39f);
    } else if(note_input == 0x20) {
        redLED = 1;
        greenLED = 0;
        blueLED = 1;
        jawServo.write(0.48f);
        baseServo.write(0.48f);
    } else if(note_input == 0x40) {
        redLED = 1;
        greenLED = 1;
        blueLED = 0;
        jawServo.write(0.55f);
        baseServo.write(0.55f);
    } else if(note_input == 0x80) {
        redLED = 0;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.63f);
        baseServo.write(0.63f);
    } else if(note_input == 0x100) {
        redLED = 1;
        greenLED = 1;
        blueLED = 0;
        jawServo.write(0.73f);
        baseServo.write(0.73f);
    } else if(note_input == 0x200) {
        redLED = 1;
        greenLED = 0;
        blueLED = 1;
        jawServo.write(0.83f);
        baseServo.write(0.83f);
    } else if(note_input == 0x400) {
        redLED = 1;
        greenLED = 0;
        blueLED = 1;
        jawServo.write(0.88f);
        baseServo.write(0.88f);
    } else if(note_input == 0x800) {
        redLED = 1;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.93f);
        baseServo.write(0.93f);
    } else {
        redLED = 1;
        greenLED = 1;
        blueLED = 1;
        jawServo.write(0.98f);
        baseServo.write(0.98f);
    }
    //wait(0.45);
}

void fallInterrupt()
{
    //int key_code=0;
    //int i=0;
    //wdt.kick();
    interrupt.fall(NULL);
    t_rest.stop();
    t.start();
    uint16_t value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    float temp_value = parse_key(value);
    if(record_mode == 0 && mem_ind < 160){
        //Write duration and silence in object
        mem_note[mem_ind] = 0;
        mem_duration[mem_ind] = t_rest.read();
        pc.printf("New Data in memory:  Note: %f  Duration: %f\n", mem_note[mem_ind], mem_duration[mem_ind]);
        mem_ind++;    
    }
    pc.printf("The time of silence seconds %f \n", t_rest.read());
    t_rest.reset();
    wait(0.1);
    float note = parse_key(value);
    if(play_live_mode == 0 || record_mode == 0){
        mySpeaker.Play_Note(note);
        dance(note);
    }
    //wdt.kick();
    //sustaining note
    while(value > 0){
        if(play_live_mode == 0 || record_mode == 0){
            mySpeaker.Play_Note(note);
        }
        wait(0.05);
        pc.printf("MPR value: %x \r\n", value);
        note = parse_key(value);
        if(play_live_mode == 0 || record_mode == 0){
            mySpeaker.Play_Note(note);
        }
        value=mpr121.read(0x00);
        value +=mpr121.read(0x01)<<8;
        //wdt.kick();
    }
    mySpeaker.Play_Note(0);
    t.stop();
    if(record_mode == 0 && mem_ind < 160){
        mem_note[mem_ind] = temp_value;
        mem_duration[mem_ind] = t.read();
        pc.printf("New Data in memory:  Note: %f  Duration: %f\n", mem_note[mem_ind], mem_duration[mem_ind]);
        mem_ind++;
    }
    t_rest.start();
    float duration[] = {t.read()};
    pc.printf("The of note seconds %f \n", t.read());
    t.reset();
    //wait(0.05);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    //wdt.kick();
}

int main()
{
    wait(1); //initialization
    //pc.printf("SystemCoreClock = %d Hz\r\n", SystemCoreClock);
    //wdt.kick(100);

    //reset_mode.fall(&reset);
    //reset_mode.rise(&reset_over);
    //reset_mode.mode(PullUp);

    jawServo.period_ms(20);
    baseServo.period_ms(20);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);

    while (1) {
        if(record_mode == 0 && reset_mode == 1) {
            redLED = 1;
            blueLED = 0;
            greenLED = 0;
            played = 0;
            //wdt.kick();
        } else if(play_back_mode == 0 && reset_mode == 1) {
            note = 0;
            redLED = 0;
            blueLED = 1;
            greenLED = 0;
            interrupt.fall(NULL); //disable interrupt
            //t.stop();
            //t.reset();
            //t_rest.stop();
            //t_rest.reset();
            for(int k = 0; k < mem_ind; k++) {
                mySpeaker.Play_Note(mem_note[k]);
                dance(mem_note[k]);
                if(reset_mode == 0){
                    break;   
                }
                wait(mem_duration[k]);
            }
            interrupt.fall(&fallInterrupt);
            interrupt.mode(PullUp);
            //wdt.kick();
        } else if(play_live_mode == 0 && reset_mode == 1) {
            note = 0;
            redLED = 0;
            blueLED = 0;
            greenLED = 1;
            played = 0;
            //wdt.kick();
        } else if(stop_mode == 0 && reset_mode == 1) {
            note = 0;
            redLED = 0;
            blueLED = 0;
            greenLED = 0;
            //wdt.kick();
        } else if(reset_mode == 0) {
            //wdt.kick();
            note = 0;
            redLED = 0;
            blueLED = 0;
            greenLED = 0;
            interrupt.fall(NULL);
            mySpeaker.Play_Note(0);
            if(!timer_begin) {
                timer_begin = 1;
                reset_timer.start();
            }
            while(reset_mode == 0) {

                //t_base.stop();
                //dt += t_base.read();
                //t_base.reset();

                //rotation orientation back to original position
                //baseServo.pulsewidth_ms(1.9);
                //wait(dt);
                //dt = 0;
                if(reset_timer.read() > 3) {
                    for(int n = 0; n < 160; n++) {
                        mem_note[n] = 0;
                        mem_duration[n] = 0;
                    }
                }
                //wdt.kick();
            }
            reset_timer.stop();
            reset_timer.reset();
            timer_begin = 1;
            mem_ind = 0;
            interrupt.fall(&fallInterrupt);
            interrupt.mode(PullUp);
        }
        //wdt.kick();
    }
}




