#include "mbed.h"
#include "Servo.h"
#include <mpr121.h>
#include "SongPlayer.h"

#define max_note 40
#define max_timer_seconds 20
#define A2 110.0
#define B2 123.0
#define C3 131.0
#define D3 185.0
#define E3 165.0
#define F3 174.614
#define G3 195.998
#define G_# 207.652

uint8_t     mode = 0;
DigitalIn   record_mode(p14);
DigitalIn   play_back_mode(p16);
DigitalIn   play_live_mode(p15);
DigitalIn   STOP(p17);
DigitalOut  GreenLED(p18);
DigitalOut  IndicatorLED(p19);
DigitalIn   RESET(p20);
I2C         i2c(p9, p10);

Mpr121      mpr121(&i2c, Mpr121::ADD_VSS);
InterruptIn interrupt(p30);
Servo       skull_jaw(p26);
Servo       skull_base(p25);
Servo       spare_servo(p24);
PwmOut      RED_LED(p23);
PwmOut      Blue_LED(p22);
SongPlayer  mySpeaker(p21);

bool expired; //Timer expiration

//Instantiate Skull Object

class skull{
  public:
      char memory[40];
      void openJaw(float angle);
      void turn_table(float angle);
      void play_tune(float tune);
      void record_memory();
      void erase_memory();
      void append_memory();
};

int main() {
    while(1) {
        if(record_mode == 1){
            mode = 1;   
        }
        if(play_back_mode == 1){
            mode = 2;
        }
        if(play_live_mode == 1){
            mode = 3;
        }
        if(STOP == 1){
            mode = 4;
        }
        switch(mode){
            case 1:
                //Record Mode
            break;
            case 2:
                //Play_back_mode
            break;
            case 3:
                //play_live_mode
            break;
            case 4:
                //Stop
            break;
            case 5:
                //Reset
            break;
        }
    }
}

void fallInterrupt() {
    //int key_code=0;
    //int i=0;
    if(mode == 1 && !expired){
        //write the recorded stuff here
    } //recording mode
    
    if(mode == 2){
        uint16_t value=mpr121.read(0x00);
        value +=mpr121.read(0x01)<<8;
        float note[] = {value + 110};
        float duration[] = {0.24};
        if(note[0]>110){
            mySpeaker.PlaySong(note, duration);}
        }
}
