#include "LSM9DS1.h"
#include "math.h"
//DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
#define M_PI 3.14 
#define printff_CALCULATED
#define printff_SPEED 250 
#define DECLINATION -8.58

void printfGyro();
void printfAccel();
void printfMag();
void printfAttitude(float mx, float my, float mz);

LSM9DS1 lol(PC4, PC5,0xD6, 0x3D);
int main() {
    //LSM9DS1 lol(p9, p10, 0x6B, 0x1E);
    
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
        while(1) ; 
    }
  
    //lol.calibrateMag() ;
    while(1) {
        
        //lol.readTemp();
        
        if ( lol.magAvailable() )
        {
        lol.readMag();
        }
        
        
        
  
        printfMag();   // printfff "M: mx, my, mz"
        pc.printf("\n") ;
        // printff the heading and orientation for fun!
        // Call printfff attitude. The LSM9DS1's mag x and y
        // axes are opposite to the accelerometer, so my, mx are
        // substituted for each other.
        printfAttitude(-lol.my, -lol.mx, lol.mz);
        pc.printf("\n") ;
        wait(1);
   } 
   }              
        





void printfMag()
{
  // Now we can use the mx, my, and mz variables as we please.
  // Either printfff them as raw ADC values, or calculated in Gauss.
  pc.printf("M: ");

  // If you want to printffff calculated values, you can use the
  // calcMag helper function to convert a raw ADC value to
  // Gauss. Give the function the value that you want to convert.
  pc.printf("mx= %f" , lol.calcMag(lol.mx), 2);
  pc.printf(", ");
  pc.printf("my= %f" , lol.calcMag(lol.my), 2);
  pc.printf(", ");
  pc.printf("mz= %f  " , lol.calcMag(lol.mz), 2);
  pc.printf(" gauss \n");
   pc.printf(" ***Raw data ****");
  pc.printf(" \n");
  pc.printf("%d" ,lol.mx);
  pc.printf(", ");
  pc.printf("%d" ,lol.my);
  pc.printf(", ");
  pc.printf("%d" ,lol.mz);

}

void printfAttitude( float hx, float hy, float mz)
{

  float heading;
  
  if (hy > 0)
  {
    heading = 90 - (atan(hx / hy) * (180 / M_PI));
  }
  else if (hy < 0)
  {
    heading = - (atan(hx / hy) * (180 / M_PI));
  }
  else // hy = 0
  {
    if (hx < 0) heading = 180;
    else heading = 0;
  }


  pc.printf("\n") ;
  pc.printf("Heading: "); pc.printf("%f" , heading, 2);
  pc.printf("\n") ;
  
}
        
      
    

