#include "mbed.h" 
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);
InterruptIn joystickcenter(p14); 
InterruptIn button(p9);
DigitalOut led(LED1); 
DigitalOut flash(LED4);
Timer debounce; // define debounce timer
int x;

 
void flip(){
 debounce.start();
 if (debounce.read_ms()>=1000) { //by adjusting the timer up it 
 // ensures the function isn’t called too often.
    led = !led; // toggles the led when the joystick button is pressed. 
    x=1;
    debounce.reset();
    }
}

int main() { 
    joystickcenter.rise(&flip); 
    // attach the function address to the rising edge 
    while(1) { // wait around, interrupts will interrupt this! 
        flash = !flash; // turns LED4 on if off, off if on 
        if (x==1){
        lcd.printf("Timer Debounce");
        x=0;
        }
    wait(0.25); // the instruction to wait for a quarter-second 
    } 

}