#include "GliderFuncTest.h"

#define TX p9
#define RX p10
#define BUZZ_PIN p26
#define SOLAR_PIN p16
#define PITOT_PIN p15
#define SDA p28
#define SCL p27

Serial pc(USBTX, USBRX);

LocalFileSystem local("test");

void log(char* s);
void logln(char* s);

GliderFuncTest test(SDA, SCL, TX, RX, SOLAR_PIN, PITOT_PIN, BUZZ_PIN);

int main() {
    while (!test.xbee->readable()) {
        test.xbee->printf("Send any char to begin...\r\n");
        wait(1);
    }
    
    test.xbee->printf("Recieved %c.  Beginning Functionality Test...\r\n", test.xbee->getc());
    
    log("Testing digital compass...");
    if (!test.testCompass()) {
        logln("FAIL.");   
    }
    wait(2);
    logln("PASS.");
   
    
    log("Testing BMP180...");
    if (!test.testBMP180()) {
        logln("FAIL.");   
    }
    wait(2);
    logln("PASS.");
    
    log("Testing solar panel voltage...");
    if (!test.testSolarVoltage()) {
        logln("FAIL.");   
    }
    wait(2);
    logln("PASS.");
    
    log("Testing pitot tube...");
    if (!test.testPitotVoltage()) {
        logln("FAIL.");   
    }
    wait(2);
    logln("PASS.");
    
    log("Testing buzzer...");
    if (!test.testBuzzer()) {
        logln("FAIL.");   
    }
    wait(2);
    logln("PASS.");
    
    logln("Testing complete.");
    
    return 0;
}

void log(char* s) {
    test.xbee->printf("%s", s);   
    pc.printf("%s", s);
}

void logln(char* s) {
    test.xbee->printf("%s\r\n", s);   
    pc.printf("%s\r\n", s);
}