#ifndef GliderFuncTest_H
#define GliderFuncTest_H

#include "mbed.h"
#include "HMC5883L.h"
#include "BMP180.h"
#include "beep.h"
#include <string>

#define PITO_V_DIVIDER 0.6666
#define SOLAR_V_DIVIDER 0.5
#define PITO_ADC_RATIO 3.3 / 0xffff

#define AIR_DENSITY 1.225 //kg per m3


class GliderFuncTest {
public:  
    GliderFuncTest(PinName sda, PinName scl, PinName tx, PinName rx, PinName solarVolt, PinName pitot, PinName buzzer);

    double heading;  //degrees from north
    float pressure;  //hpa
    float temp;  //C
    float alt;  //m
    float speed;  //m per s
    float solarVoltage;  //volts
    HMC5883L* hmc;  //magnetometer object
    BMP180* bmp;  //pressor sensor object
    Serial* xbee;
    
    AnalogIn pitotInput;
    AnalogIn solarInput;
    Beep buzzerOutput;
    
    bool testCompass();
    bool testBMP180();
    bool testSolarVoltage();
    bool testPitotTube();
    bool testBuzzer();
};

#endif