#include "GliderFuncTest.h"

GliderFuncTest::GliderFuncTest(PinName sda, PinName scl, PinName tx, PinName rx, PinName solarVolt, PinName pitot, PinName buzzer)
    : pitotInput(pitot), buzzerOutput(buzzer), solarInput(solarVolt) {
        xbee = new Serial(tx, rx);
        hmc = new HMC5883L(sda, scl);
        hmc->init();
        bmp = new BMP180(sda, scl);
        bmp->Initialize(64, BMP180_OSS_ULTRA_LOW_POWER);
}

bool GliderFuncTest::testCompass() {
    bool res = false;
    
    this->heading = this->hmc->getHeading();  
    
    if (this->heading >= 0) {
        res = true;   
    }  
    
    return res;
}

bool GliderFuncTest::testBMP180() {
    bool res = false;
    
    bmp->ReadData(&this->temp, &this->pressure, &this->alt);
    
    if (this->temp > 0 && this->pressure > 0 && this->alt > 0) {
        res = true;
    }
    
    return res;
}

bool GliderFuncTest::testSolarVoltage() {
    bool res = false;
    
    solarVoltage = solarInput.read_u16() * PITO_ADC_RATIO;
    solarVoltage = solarVoltage / SOLAR_V_DIVIDER; 
    
    if (solarVoltage > 0) {
        res = true;
    }
    
    return res;
}

bool GliderFuncTest::testPitotTube() {
    bool res = false;
    
    float vInput =  this->pitotInput.read_u16() * PITO_ADC_RATIO;
    vInput = vInput / PITO_V_DIVIDER;
    
    float diffPressure = (vInput - 0.5) / (0.2 * 5.0);  //kPa
    this->speed = sqrt((2*diffPressure) / AIR_DENSITY);
    
    if (this->speed > 0) {
        res = true;   
    }
    
    return res;
}

bool GliderFuncTest::testBuzzer() {
    buzzerOutput.beep(700, 4, false);
    return true;
}

