#ifndef Glider_H
#define Glider_H

#include "mbed.h"
#include <string>
#include "math.h"
#include "HMC5883L.h"
#include "BMP180.h"
#include "beep.h"

#define SAVE_DATA_FORMAT "%d %d %d"  //string format for the data saved to flash mem
#define PACKET_FORMAT "3387, GLIDER, %d, %u, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %d\r\n"  //string format for telemetry packet

#define CMD_BUZZER 'b'  //sound buzzer for 3 seconds  
#define CMD_RESET 'z'  //zero out packet count, mission time, and state
#define CMD_NEXT_STATE 'n'  //increment state
#define CMD_PREV_STATE 'p'  //decrement state

#define FREQ 1.0  //frequency of sending a telem packet (1 a second)

#define CRUZE 0  //released from container
#define LAND 1  //on the ground

#define PITO_V_DIVIDER 0.6666
#define SOLAR_V_DIVIDER 0.5
#define PITO_ADC_RATIO 3.3 / 0xffff

#define AIR_DENSITY 1.225 //kg per m3

#define BUZZER_FREQ 700.0

#define ALT_THRESH -1.0 //meters

#define EMERGENCY_TIMEOUT 60.0  //seconds before buzzer will sound forever no matter what

class Glider {
public:
    Serial* dev;
    Serial* xbee;  //xbee radio
    double heading;  //degrees from north
    float pressure;  //hpa
    float temp;  //C
    float alt;  //m
    float speed;  //m per s
    float solarVoltage;  //volts
    bool cmdFlag;  //goes true when a command is recieved
    bool transmitFlag;  //goes true once a second
    time_t startTime;  //saved data  
    time_t missionTime;  //current time - initial time
    uint8_t packetCount;  //saved data
    uint8_t state;  //saved data
    HMC5883L* hmc;  //magnetometer object
    BMP180* bmp;  //pressor sensor object
    
    //constructor for glider object
    Glider(Serial* device, PinName sda, PinName scl, PinName tx, PinName rx);
    InterruptIn xbeeRxInt;  //ISR for RX external interrupt
    AnalogIn pitot;
    AnalogIn solVoltIn;
    Beep buzzer;
    void setHeading();
    void setTempPressAlt();
    void setAirSpeed();
    void setSolarVoltage();
    void setMissionTime();
    void setTransmitFlag();
    void forceLandState();
    void updateTelem();
    void initSaveData();
    void saveTelem();
    void saveData();
    void transmitPacket();
    void setCommandFlag();
    void processCommand();
    void soundBuzzer(float freq, float dur, bool infinate);
    void checkForLand();
    void endMission();
};

#endif
