#include "Glider.h"

Serial pc(USBTX, USBRX);
LocalFileSystem local("telem");
Ticker transmitTimer;
Timeout emergencyAlarm;

int main() {
    Glider g(&pc, p28, p27, p9, p10);
    transmitTimer.attach(&g, &Glider::setTransmitFlag, FREQ); 
    emergencyAlarm.attach(&g, &Glider::forceLandState, EMERGENCY_TIMEOUT);
    
    while (1) {
        
        //g.saveData();
        g.updateTelem();
        
        switch (g.state) {
            case CRUZE:
                //g.checkForLand();  
                break;
            case LAND:
                transmitTimer.detach();
                g.endMission(); 
                break;
        }
        
        if (g.transmitFlag) {
            g.updateTelem();
            g.saveData();
            g.saveTelem();
            g.transmitPacket();
            g.transmitFlag = false;   
        }

        g.processCommand();
    }

}

