#include "mbed.h"
#include "mRotaryEncoder.h"

/** Test the Library for mechanical rotary encoders with pushbutton 
 * like this one from alps  http://www.alps.com/WebObjects/catalog.woa/E/HTML/Encoder/Incremental/EC11/EC11E09244BS.shtml
 * should work for any other incremental encoder with button
 */

// mbed LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial pcout(USBTX, USBRX);


//mRotaryEncoder(PinName pinA, PinName pinB, PinName pinSW, PinMode pullMode=PullUp, int debounceTime_us=1000)
mRotaryEncoder  wheel(p21, p22, p23);


int lastGet;
int thisGet;


bool enc_pressed = false;      // Button of rotaryencoder was pressed
bool enc_rotated = false;      // rotary encoder was totaded left or right


//interrup-Handler for button on rotary-encoder
void trigger_sw() {
    enc_pressed = true;               // just set the flag, rest is done outside isr
}

//interrup-Handler for rotary-encoder rotation
void trigger_rotated() {
    enc_rotated = true;               // just set the flag, rest is done outside isr
}


// display int-Value on the 4 LEDS
void displayLED(int value) {
    switch (abs(value) % 4) { // Get 2 LSBs and display sequence on mbed LEDs
        case 0:
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
        case 1:
            led1 = 0;
            led2 = 1;
            led3 = 0;
            led4 = 0;
            break;
        case 2:
            led1 = 0;
            led2 = 0;
            led3 = 1;
            led4 = 0;
            break;
        default:
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 1;
            break;
    } // switch
}

int main() {

    pcout.printf("\n\rconnected to mbed...\n\r");

    //Int-Handler
    // call trigger_sw() when button of rotary-encoder is pressed
    wheel.attachSW(&trigger_sw);

    // call trigger_rot() when the shaft is rotaded left or right
    wheel.attachROT(&trigger_rotated);

    lastGet = 0;

    // set encrotated, so position is displayed on startup
    enc_rotated = true;

    while (1) {


        // shaft has been rotated?
        if (enc_rotated) {
            enc_rotated = false;

            thisGet = wheel.Get();

            displayLED(thisGet);
            pcout.printf ("Pulses is: %i\n\r", thisGet);

        }


        // Button pressed?
        if (enc_pressed) {
            enc_pressed = false;
            printf("triggered!\n\r");

            wheel.Set(0);

            //Update displays
            thisGet = wheel.Get();
            displayLED(thisGet);
            pcout.printf ("\n\rPulses is: %i\n\r", thisGet);

        }
        //do something else
        
    }

}
