#include "mbed.h"
#include "rfm12b.h"
#include "rfm.h"

/*!
 * \file       rfm12b.cpp
 * \brief      class for rfm2b in rawmode - only receive part implemented
 * \author     Karl Zweimüller based on code from WED 6.9.2009
 */


/** Class rfm12b for RFM12B transceiver module
  http://www.hoperf.com/rf_fsk/rfm12b.htm
*/

/** rfm12b object
*/
rfm12b::rfm12b(PinName mosi, PinName miso, PinName sclk, PinName nsel, PinName rxdata) {

    rfm12b_spi  = new SPI(mosi, miso, sclk);   // mosi, miso, sclk
    cs          = new DigitalOut(nsel);        // nsel for chipselect
    m_pinRXData = new InterruptIn(rxdata);     // rxData- generates interrupts

    init_spi();            // init the spi-device
}

/** init the spi-communication
*/
void rfm12b::init_spi() {
    // Setup the spi for 16 bit data : 1RW-bit 7 adressbit, 8 databit
    // second edge capture, with a 5MHz clock rate
    rfm12b_spi->format(16,0);
    rfm12b_spi->frequency(5000000);
}

///////////////////////////////////////////////////////////////////////////////
//
// Initialise RF module
// This are parameters for ETH Comfort by ELV
///////////////////////////////////////////////////////////////////////////////
void rfm12b::RFM_init(void) {

    // 0. Init the SPI backend
    //RFM_TESTPIN_INIT;

    //RFM_READ_STATUS();

    // 1. Configuration Setting Command
    RFM_SPI_16(
        //RFM_CONFIG_EL           |
        //RFM_CONFIG_EF           |
        RFM_CONFIG_BAND_868     |
        RFM_CONFIG_X_11_0pf
    );

    // 2. Power Management Command
    //RFM_SPI_16(
    //     RFM_POWER_MANAGEMENT     // switch all off
    //     );

    // 3. Frequency Setting Command
    RFM_SPI_16(
        RFM_FREQUENCY            |
        RFM_FREQ_868Band(868.30)
    );

    // 4. Data Rate Command
    RFM_SPI_16(RFM_DATA_RATE_9600);

    // 5. Receiver Control Command
    RFM_SPI_16(
        RFM_RX_CONTROL_P20_VDI  |
        RFM_RX_CONTROL_VDI_FAST |
        //RFM_RX_CONTROL_BW(RFM_BAUD_RATE) |
        RFM_RX_CONTROL_BW_134 |
        RFM_RX_CONTROL_GAIN_0   |
        RFM_RX_CONTROL_RSSI_73
    );

    // 6. Data Filter Command
    RFM_SPI_16(
        //RFM_DATA_FILTER_AL      |
        //RFM_DATA_FILTER_ML      |
        //RFM_DATA_FILTER_DQD(3)
        RFM_DATA_FILTER_ANALOG
    );

    // 7. FIFO and Reset Mode Command
    RFM_SPI_16(
        RFM_FIFO_IT(8) |
        RFM_FIFO_DR
    );

    // 8. Receiver FIFO Read

    // 9. AFC Command
    RFM_SPI_16(
        RFM_AFC_AUTO_VDI        |
        RFM_AFC_RANGE_LIMIT_7_8 |
        RFM_AFC_EN              |
        RFM_AFC_OE              |
        RFM_AFC_FI
    );

    // 10. TX Configuration Control Command
    RFM_SPI_16(
        RFM_TX_CONTROL_MOD_30 |
        RFM_TX_CONTROL_POW_0
    );

    // 11. Transmitter Register Write Command

    // 12. Wake-Up Timer Command

    // 13. Low Duty-Cycle Command

    // 14. Low Battery Detector Command

    //RFM_SPI_16(
    //     RFM_LOW_BATT_DETECT |
    //     3      // 2.2V + v * 0.1V
    //     );

    // 15. Status Read Command
    //RFM_SPI_16(RFM_TX_ON());
    RFM_SPI_16(RFM_RX_ON());

}

///////////////////////////////////////////////////////////////////////////////



/** write and read 16 bit to device
*/
uint16_t rfm12b::rfm_spi16(uint16_t outval) {

    uint16_t    readval;
    // Select the device by seting chip select low
    cs->write(0);
    wait_ms(1);               // wait before going on
    //write and read
    readval = rfm12b_spi->write(outval);
    // Deselect the device
    cs->write(1);
    wait_ms(1);               // wait before going on
    return(readval);
}


