#include "mbed.h"

#include "TextLCD.h"

#include "eth_comfort.h"
#include "rfm.h"
#include "rfm12b.h"

/*!
 * \file       main.cpp
 * \brief      Show the messages from ETH-Radio-Shutters on serial port and lcd
 * \author     Karl Zweimüller
 */

TextLCD lcd(p30, p29, p28, p27, p26, p25, TextLCD::LCD16x2); // rs, e, d0-d3

eth_comfort eth_comf(p11, p12, p13, p14, p18, LED4); // mosi, miso, sclk, cs, rxdata, rxled

Serial pc(USBTX, USBRX); // tx, rx

// mbed LEDs
/*
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
*/

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

int main() {

    eth_message message;

    pc.baud(115200);

    pc.printf("\n\rConnected to mbed\n\r");
    lcd.printf("Hello!\n");

    do {
        // anything new?
        if (eth_comf.readable()) {
            // read the new message and display
            message = eth_comf.getMessage();
            pc.printf("\n\rCounter: %02X\n\r",message.cnt);
            pc.printf(    " Dev-ID: %06X\n\r",message.adr);
            pc.printf(    "    cmd: %0X\n\r",message.cmd);
            //pc.printf(    "cmd&0x80: %0X\n\r",message.cmd&0x80);
            // why doesn't work the following??????????????
            //pc.printf(    "Battery: ");
            //if (message.cmd&0x80 == 0x00) pc.printf("GOOD\n\r"); else pc.printf("WEAK\n\r");

            pc.printf(    "Window : %s\n\r\n\r", (message.cmd&0x01 != 0x00) ? "OPEN" : "CLOSE");
            lcd.cls();
            lcd.printf("#:%02X ID: %06X\n",message.cnt,message.adr);
            lcd.printf("Window : %s\n", (message.cmd&0x01 != 0x00) ? "OPEN" : "CLOSE");
            pc.printf("\n\r");
        }
    } while (1==1);

}


