#ifndef ETH_COMFORT_H
#define ETH_COMFORT_H

/*!
 * \file       eth_comfort.h
 * \brief      Read the messages from the ETH-Radio-Shutter
 * \author     Karl Zweimüller 
 */


#include "mbed.h"

#include "rfm12b.h"

// a message from the eth-Device
struct eth_message {
    uint8_t    cnt;                //message-counter
    uint8_t    len;                //message-length
    uint32_t   adr;                // unique address of device
    uint8_t    cmd;                // the command
    uint8_t    data;               // optional data
    uint8_t    xdata;              // optional extra data
    uint16_t   crc;                // crc fro the message
};

/**
  * Class for the ETH-Window shutter by ELV(R)
  * Uses the rfm12B to receive the signals sent by the radio-shutter
  *
 */
class eth_comfort {

public:

    /**
     * Constructor.
    *
    * @param mosi SPI-Interface. One of the 2 PSI-Interfaces of mbed. Pin p5 or p11
    * @param miso SPI-Interface. One of the 2 PSI-Interfaces of mbed. Pin p6 or p12
    * @param sclk SPI-Interface. One of the 2 PSI-Interfaces of mbed. Pin p7 or p13
    * @param nsel Chip-Select.   A Digial Output of mbed
    * @param rxdata  Data-Pin for received data. A DigitalIn of mbed
    * @param rxled   LED1 - LED4 for showing received bytes
    */
    eth_comfort(PinName mosi, PinName miso, PinName sclk, PinName nsel, PinName rxdata, PinName rxled);


// initialize eth_comfort-receiver
    void init();

// is a new message readable - non blocking
    bool readable();

// read a eth-messsage - non blocking, shows the old message if no new is available
    eth_message getMessage();



private:

// Interrupt Routine
    void ISR();

// the last received message
    eth_message last_message;

// new meeesage
    eth_message new_message;

// is a new message in the buffer?
    bool message_received;

// calcualte the crc for eth
    uint16_t calcCRC16r( uint16_t c,uint16_t crc, uint16_t mask);

    volatile uint8_t bit_cnt;
    volatile uint16_t buffer_cnt;

    volatile uint8_t rbyte;

    volatile uint8_t buf[1024];
    volatile uint8_t pack_ok,startbit;
    volatile uint8_t decode,bcnt,lastbit;
    volatile uint8_t state;
    volatile uint16_t b;
    volatile uint8_t blocklength;
    int i,j,k;
    bool  crc_ok;
    uint16_t crc, swapped;

    rfm12b *rfm12b_spi;

    DigitalOut *rxLED;

};

#endif

