#include "mbed.h"

# include "string.h"

#include "TextLCD.h"

#include "ConfigFile.h"

#include "eth_comfort.h"
#include "rfm.h"
#include "rfm12b.h"

/*!
 * \file       main.cpp
 * \brief      Read messages from ETH-Radio-Shutters and send On/Off-Commands to KNX (via freebus-rs-interface)
 * \author     Karl Zweimüller
 */

TextLCD lcd(p30, p29, p28, p27, p26, p25, TextLCD::LCD16x2); // rs, e, d0-d3

eth_comfort eth_comf(p11, p12, p13, p14, p18, LED4); // mosi, miso, sclk, cs, rxdata, rxled

Serial pc(USBTX, USBRX); // tx, rx

//Freebus-RS-Interface connected to serial
Serial knxrs(p9, p10);  // tx, rx

// Filesystem for Config-File
LocalFileSystem local("local");

ConfigFile cfg;

// mbed LEDs
/*
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
*/

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

int main() {

    char group[255];                          // the KNX-Group-address
    char ethid[255];                          //the ETH-ID  as string
    char command[255];                        // a command to send to the freebus rs-interface

    eth_message message;                      // holds a message from the ETH-window-shutter

    pc.baud(115200);

    pc.printf("\n\rConnected to mbed\n\r");
    lcd.printf("ETH-Freebus: OK\n");

    /*
     * Read the configuration file from mbed.
     */
    if (!cfg.read("/local/knx.cfg")) {
        pc.printf("Failure to read configuration file knx.cfg.\n\r");
    }


    // initialize freebus-rs-interface
    // 115.200 Baud,n,8,1
    knxrs.baud(115200);

    knxrs.printf("fbecho=0\r");   //switch off echo


    do {
        // anything new?
        if (eth_comf.readable()) {
            // read the new message and display
            message = eth_comf.getMessage();
            pc.printf("\n\rCounter: %02X\n\r",message.cnt);
            pc.printf(    " Dev-ID: %06X\n\r",message.adr);
            pc.printf(    "    cmd: %0X\n\r",message.cmd);
            //pc.printf(    "cmd&0x80: %0X\n\r",message.cmd&0x80);
            // why doesn't work the following??????????????
            //pc.printf(    "Battery: ");
            //if (message.cmd&0x80 == 0x00) pc.printf("GOOD\n\r"); else pc.printf("WEAK\n\r");

            pc.printf(    "Window : %s\n\r\n\r", (message.cmd&0x01 != 0x00) ? "OPEN" : "CLOSE");
            lcd.cls();
            lcd.printf("#:%02X ID: %06X\n",message.cnt,message.adr);
            lcd.printf("Window : %s\n", (message.cmd&0x01 != 0x00) ? "OPEN" : "CLOSE");
            pc.printf("\n\r");


            // convert id to string
            sprintf(ethid,"%06X",message.adr);
            /*
            * Get the group address from configuration value.
            */
            if (cfg.getValue(ethid, &group[0], sizeof(group))) {
                pc.printf("Config-File: '%s'='%s'\n\r", ethid,group );
            } else {
                strcpy(group ,"");
            }


            if (strlen(group) > 0) {
                sprintf(command, "fbs01/%s=%s\r",group,(message.cmd&0x01 != 0x00) ? "1" : "0");  // EIS01 on Group-address group : Open=1 Close=0
                // Send a KNX-Telegramm
                knxrs.printf("%s",command);
                pc.printf("%s\n\r",command);
            } else {
                // device not in config file, so add it
                // add the new device to the config and write file
                pc.printf("new unknown device!\n\r");
                /* we don't write the file, as all comments are lost
                if (!cfg.setValue(ethid, "")) {
                    error("Failure to set a value.\n\r");
                }
                if (!cfg.write("/local/knx.cfg")) {
                    error("Failure to write the configuration file.\n\r");
                }
                */
            }
        }
    } while (1==1);

}


