#include "mbed.h"
#include "WordClock.h"
#include "neopixel.h"

WordClock::WordClock (PinName pin) : di_pin_(pin, PullDown), array_(pin)
{

    // Create a temporary DigitalIn so we can configure the pull-down resistor.
    // (The mbed API doesn't provide any other way to do this.)
    // An alternative is to connect an external pull-down resistor.
    //DigitalIn(pin, PullDown);
    // The pixel array control class.
    //neopixel::PixelArray array(pin);

    // initialize hsv
    //hue_ = 0.0;             //red
    hue_ = 0.2917;            //limett-green
    saturation_ = 1.0;      //full color
    value_ = 1.0;           //brightness

}

/** Convert a color from the HSV representation to RGB.
 *
 * @param h hue 0.0 ... 1.0
 * @param s saturation 0.0 ... 1.0
 * @param v value 0.0 ... 1.0
*/
neopixel::Pixel WordClock::hsvToRgb(float h, float s, float v)
{
    int i = floor(h * 6);
    float f = h * 6 - i;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;
    switch(i % 6) {
        case 0:
            r = v;
            g = t;
            b = p;
            break;
        case 1:
            r = q;
            g = v;
            b = p;
            break;
        case 2:
            r = p;
            g = v;
            b = t;
            break;
        case 3:
            r = p;
            g = q;
            b = v;
            break;
        case 4:
            r = t;
            g = p;
            b = v;
            break;
        case 5:
            r = v;
            g = p;
            b = q;
            break;
    }
    return (neopixel::Pixel) {
        r * 255, g * 255, b * 255
    };
}

void WordClock::cls()
{
    int i;
    for (i=0; i<NUMLEDS; i++) {
        ledstripe_[i].red=0;
        ledstripe_[i].green=0;
        ledstripe_[i].blue=0;
    }
}

void WordClock::es_ist()
{
    ledstripe_[0] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[1] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[3] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[4] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[5] = hsvToRgb(hue_, saturation_, value_);
}
void WordClock::fuenf_m()
{
    ledstripe_[7] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[8] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[9] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[10]= hsvToRgb(hue_, saturation_, value_);
}
void WordClock::zehn_m()
{
    ledstripe_[21] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[20] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[19] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[18] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::zwanzig()
{
    ledstripe_[17] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[16] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[15] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[14] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[13] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[12] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[11] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::drei_m()
{
    ledstripe_[22] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[23] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[24] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[25] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::vier_m()
{
    ledstripe_[26] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[27] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[28] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[29] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::tel()
{
    ledstripe_[30] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[31] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[32] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::nach()
{
    ledstripe_[41] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[40] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[39] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[38] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::vor()
{
    ledstripe_[37] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[36] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[35] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::halb()
{
    ledstripe_[44] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[45] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[46] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[47] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::zwoelf()
{
    ledstripe_[49] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[50] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[51] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[52] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[53] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::zwei()
{
    ledstripe_[65] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[64] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[63] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[62] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::eins()
{
    ledstripe_[63] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[62] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[61] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[60] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::ein()
{
    ledstripe_[63] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[62] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[61] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::sieben()
{
    ledstripe_[60] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[59] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[58] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[57] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[56] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[55] = hsvToRgb(hue_, saturation_, value_);

}

void WordClock::drei_h()
{
    ledstripe_[67] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[68] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[69] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[70] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::fuenf_h()
{
    ledstripe_[73] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[74] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[75] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[76] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::elf()
{
    ledstripe_[87] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[86] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[85] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::neun()
{
    ledstripe_[84] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[83] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[82] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[81] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::vier_h()
{
    ledstripe_[80] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[79] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[78] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[77] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::acht()
{
    ledstripe_[89] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[90] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[91] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[92] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::zehn_h()
{
    ledstripe_[93] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[94] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[95] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[96] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::sechs()
{
    ledstripe_[108] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[107] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[106] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[105] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[104] = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::uhr()
{
    ledstripe_[101] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[100] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[99]  = hsvToRgb(hue_, saturation_, value_);
}

void WordClock::m1(int second)
{
    ledstripe_[110] = hsvToRgb(hue_, saturation_, float(second)/60);
}

void WordClock::m2(int second)
{
    ledstripe_[111] = hsvToRgb(hue_, saturation_, float(second)/60);
}

void WordClock::m3(int second)
{
    ledstripe_[112] = hsvToRgb(hue_, saturation_, float(second)/60);
}

void WordClock::m4(int second)
{
    ledstripe_[113] = hsvToRgb(hue_, saturation_, float(second)/60);
}

void WordClock::sz()
{
    cls();
    ledstripe_[4] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[17] = hsvToRgb(hue_, saturation_, value_);
    array_.update(ledstripe_,NUMLEDS);
}

void WordClock::wz()
{
    cls();
    ledstripe_[16] = hsvToRgb(hue_, saturation_, value_);
    ledstripe_[13] = hsvToRgb(hue_, saturation_, value_);
    array_.update(ledstripe_,NUMLEDS);
}

void WordClock::test_display(int option, int index)
{
    cls();
    //build and display the content of ledarray
    switch (option) {
        case 1 : {
            // color gradient from red to red through hsv colors
            for (int i=0; i<NUMLEDS; i++) {
                ledstripe_[i] = hsvToRgb(1.0*i/NUMLEDS, saturation_, value_);
            }
            array_.update(ledstripe_,NUMLEDS);
            break;
        }
        case 2 : {
            //display one LED in White, full brightness
            ledstripe_[index] = hsvToRgb(1.0, 0.0, 1.0);//white
            array_.update(ledstripe_,NUMLEDS);
            break;
        }
        case 3 : {
            //display a word
            cls();
            switch (index) {
                case 1: {
                    es_ist();
                    break;
                }
                case 2: {
                    fuenf_m();
                    break;
                }
                case 3: {
                    zehn_m();
                    break;
                }
                case 4: {
                    zwanzig();
                    break;
                }
                case 5: {
                    drei_m();
                    break;
                }
                case 6: {
                    vier_m();
                    break;
                }
                case 7: {
                    tel();
                    break;
                }
                case 8: {
                    nach();
                    break;
                }
                case 9: {
                    vor();
                    break;
                }
                case 10: {
                    halb();
                    break;
                }
                case 11: {
                    zwoelf();
                    break;
                }
                case 12: {
                    zwei();
                    break;
                }
                case 13: {
                    eins();
                    break;
                }
                case 14: {
                    sieben();
                    break;
                }
                case 15: {
                    drei_h();
                    break;
                }
                case 16: {
                    fuenf_h();
                    break;
                }
                case 17: {
                    elf();
                    break;
                }
                case 18: {
                    neun();
                    break;
                }
                case 19: {
                    vier_h();
                    break;
                }
                case 20: {
                    acht();
                    break;
                }
                case 21: {
                    zehn_h();
                    break;
                }
                case 22: {
                    sechs();
                    break;
                }
                case 23: {
                    uhr();
                    break;
                }
                case 24: {
                    m1();
                    break;
                }
                case 25: {
                    m2();
                    break;
                }
                case 26: {
                    m3();
                    break;
                }
                case 27: {
                    m4();
                    break;
                }
                case 28: {
                    ein();
                    break;
                }


            }//switch
            array_.update(ledstripe_,NUMLEDS);
            break;
        }
    }//switch
}

void WordClock::display_time(int hour,int minute, int second)
{
    //display the time in words
    if (hour < 0  ) hour = 0;
    if (hour > 23 ) hour = 23;
    if (minute <  0) minute = 0;
    if (minute > 59) minute = 59;
    if (second <  0) second = 0;
    if (second > 59) second = 59;

    //set the color depending on the hour
    hue_ = float(hour)/24; 

    cls();
    es_ist();
    //minutes
    if (minute >=5 and minute <10) {
        fuenf_m();
        nach();
    }
    if (minute >=10 and minute <15) {
        zehn_m();
        nach();
    }
    if (minute >=15 and minute <20) {
        vier_m();
        tel();
        nach();
    }
    if (minute >=20 and minute <25) {
        zwanzig();
        nach();
    }
    if (minute >=25 and minute <30) {
        fuenf_m();
        vor();
        halb();
        hour++;
    }
    if (minute >= 30 and minute<35) {
        halb();
        hour++;
    }
    if (minute >=35 and minute<40) {
        fuenf_m();
        nach();
        halb();
        hour++;
    }
    if (minute >=40 and minute<45) {
        zwanzig();
        vor();
        hour++;
    }
    if (minute >=45 and minute<50) {
        drei_m();
        vier_m();
        tel();
        hour++;
    }
    if (minute >=50 and minute<55) {
        zehn_m();
        vor();
        hour++;
    }
    if (minute >=55 and minute<60) {
        fuenf_m();
        vor();
        hour++;
    }
    //hours
    if (hour >=13) hour -= 12;
    switch (hour){
        case 0:{
            zwoelf();
            break;
        }
        case 1:{
            if (minute < 5) {
                ein();
            }else{
                eins();
            }
            break;
        }
        case 2:{
            zwei();
            break;
        }
        case 3:{
            drei_h();
            break;
        }
        case 4:{
            vier_h();
            break;
        }
        case 5:{
            fuenf_h();
            break;
        }
        case 6:{
            sechs();
            break;
        }
        case 7:{
            sieben();
            break;
        }
        case 8:{
            acht();
            break;
        }
        case 9:{
            neun();
            break;
        }
        case 10:{
            zehn_h();
            break;
        }
        case 11:{
            elf();
            break;
        }
        case 12:{
            zwoelf();
            break;
        }        
    }//switch hour
    
    //only on full hours
    if (minute < 5) {
        uhr();
    }
    
    //minutes 0..4 and seconds in brigtness
    switch (minute%5){
        case 0:{
            m1(second);
            break;
        }
        case 1:{
            m1();
            m2(second);
            break;
        }
        case 2:{
            m1();
            m2();
            m3(second);
            break;
        }
        case 3:{
            m1();
            m2();
            m3();
            m4(second);
            break;
        }
        case 4:{
            // we don't have a 5th led for minute 4..5
            // dim down all 4 LEDs 
            m1(59-second);
            m2(59-second);
            m3(59-second);
            m4(59-second);
            break;
        }
    }//switch minute%5
    //display the LED-Array
    array_.update(ledstripe_,NUMLEDS);
}
