#ifndef WORDCLOCK_H
#define WORDCLOCK_H

#include "mbed.h"
#include "neopixel.h"

/** class to display Time on WS2812B-LED-Stripe
 *  Drive LEDs with PixelArray
 *  with 11x10 LED-Matrix and 4 minute-LEDS
 *
 * GERMAN LAYOUT !!!!!!
 *
 
ESKISTLFÜNF
ZEHNZWANZIG
DREIVIERTEL
TGNACHVORJM
HALBXZWÖLFP
ZWEINSIEBEN
KDREIRHFÜNF
ELFNEUNVIER
WACHTZEHNRS
BSECHSFMUHR
   ****

*/  

// Number of LEDS in Stripe
#define NUMLEDS 114

//Number of different words
#define NUMWORDS 28

/** Class: WorldClock
 *  A class to show time in words with LED-Stripe
 */
class WordClock {

public:

/** Create a WordClock Object with WS2812B-LEDs connected to pin (must be a SPI-MOSI-pin)
 *
 * @param pin SPI-MOSI pin to connect LEDs
 */
    WordClock (PinName pin);
    
/** display_time(hour, minute, second)
*
* @param time time to display
*
*/
    void display_time(int hour,int minute, int second = 0);

/** test_display(int option)
*
* @param option option for test
*      1   color gradient from red to red through hsv colors.
*      2   display one LED in White, full brightness.
*      3   display a word.
* @param index index for test. Which LED/word to set. 0..NUMLEDS, 0..NUMWORDS
*
*/
    void test_display(int option, int index = 0);    

/** Convert a color from the HSV representation to RGB.
 *
 * @param h hue 0.0 ... 1.0
 * @param s saturation 0.0 ... 1.0
 * @param v value 0.0 ... 1.0
*/ 
neopixel::Pixel hsvToRgb(float h, float s, float v);

private :
    //clear ledstripe (without displaying)
    void cls();
    
    // all words
    void es_ist();
    void fuenf_m();
    void zehn_m();
    void zwanzig();
    void drei_m();
    void vier_m();
    void tel();
    void nach();
    void vor();
    void halb();
    void zwoelf();
    void zwei();
    void eins();
    void ein();
    void sieben();
    void drei_h();
    void fuenf_h();
    void elf();
    void neun();
    void vier_h();
    void acht();
    void zehn_h();
    void sechs();
    void uhr();
    void m1(int second = 59);
    void m2(int second = 59);
    void m3(int second = 59);
    void m4(int second = 59);
    
public:
/** display SZ for Sommerzeit
*/
    void sz(); //Sommerzeit
/** display WZ for Winterzeit
*/    
    void wz(); //Winterzeit
private:

    //Digitalin for Pulldown
    DigitalIn di_pin_; 

    // The pixel array control class.
    neopixel::PixelArray array_;
    
    // the array of leds
    neopixel::Pixel ledstripe_[NUMLEDS];
    
  
    //Hue-Value (HSV)for LEDS
    float hue_;
    
    // Saturation (HSV)for LEDs
    float saturation_;

    //brightness/value(HSV) for LEDS
    float value_;
    
};

#endif
