// Wordclock with WS2812-LED-Stripe
// with 11x10 LED-Matrix and 4 minute-LEDS
// and DS3231 RTC
/*

ESKISTLFÜNF
ZEHNZWANZIG
DREIVIERTEL
TGNACHVORJM
HALBXZWÖLFP
ZWEINSIEBEN
KDREIRHFÜNF
ELFNEUNVIER
WACHTZEHNRS
BSECHSFMUHR
   ****
*/


#include "mbed.h"
#include "neopixel.h"
#include "WordClock.h"
#include "ds3231.h"

/** add simple DST info to nvram of ds3231
* we abuse bit RS1(bit3) from control-register which normally controls frequency of output-pin
*/
class Ds3231_dst : public Ds3231
{
public:
    Ds3231_dst(PinName sda, PinName scl) : Ds3231(sda,scl) {}

/** set_DST(bool dst)
*/      
    uint16_t set_DST(bool dst) {
        ds3231_cntl_stat_t data = {0xAA, 0xAA};
        uint16_t rtn_val;
        // first read CR
        rtn_val = get_cntl_stat_reg(&data);
        // applay dst
        if (dst) {
            data.control |= 1<<3;
        } else {
            data.control &= ~(1<<3);
        }
        //write back
        rtn_val = set_cntl_stat_reg(data);
        return 0;
    }
/** bool get_DST()
*/
    bool get_DST() {
        ds3231_cntl_stat_t data = {0xAA, 0xAA};
        uint16_t rtn_val;
        // first read CR
        rtn_val = get_cntl_stat_reg(&data);
        // get dst
        if (data.control & (1<<3)) {
            return true;
        } else {
            return false;
        }
    }
};

int main()
{

    // WordClock object with leds connected to p5 (MOSI)
    WordClock clock(p5);

    //RTC with DS3231 : sda, scl
    Ds3231_dst rtc(p9, p10);

    Timer timer;
    
    //DaylightSavingTIme?
    bool DST = false;

    //Serial pc(USBTX, USBRX); // tx, rx
    {
        //pc.baud(115200);
        //pc.printf("\n\rconnected to mbed - WordClock...\n\r");
        
        // set time and date
        //time and calendar variables
        ds3231_time_t time = {0, 39, 21, 0, 0};      //sec, min, hour, am/pm(1=pm), mode(1=12h)
        ds3231_calendar_t calendar = {1, 6, 11, 17};  //day(1=mon), date, month, year(2 digits)
        uint16_t rtn_val;
        // only set RTC when required!
//        rtn_val = rtc.set_time(time);
//        rtn_val = rtc.set_calendar(calendar);
//        rtn_val = rtc.set_DST(false);

        // initial display

        // show Winterzeit/Sommerzeit as stored in RTC
        if (rtc.get_DST()){
            // SZ for Sommerzeit
            clock.sz();
            DST = true;
        }else{
            //WZ for Winterzeit
            clock.wz();
            DST = false;
        }
        wait(2); 

        while (1) { //display loop

            //read time 
            rtn_val = rtc.get_time(&time);
            //pc.printf("%2d:%2d ",time.hours,time.minutes);

            // read date
            rtn_val = rtc.get_calendar(&calendar);
            //pc.printf("%2d.%2d.%2d - day:%d \n\r",calendar.date, calendar.month,calendar.year, calendar.day);
            

            // check for DST time change 
            // only valid for europe!!!
            // see http://www.instructables.com/id/The-Arduino-and-Daylight-Saving-Time-Europe/

            //switch to ~DST on last sunday in october
            if (calendar.day == 7 && calendar.month == 10 && calendar.date >= 25 && time.hours == 3 && DST==true){
                time.hours=2;
                DST=false;
                rtc.set_time(time);
                rtc.set_DST(DST);
                //show WZ
                clock.wz();
                wait(2);
            }
            //switch to DST on last sunday in march
            if (calendar.day == 7 && calendar.month == 3 && calendar.date >= 25 && time.hours == 2 && DST==false){
                time.hours=3;
                DST=true;
                rtc.set_time(time);
                rtc.set_DST(DST);
                //show SZ
                clock.sz();
                wait(2);
            }
            
            //display time
            clock.display_time(time.hours,time.minutes,time.seconds);
            wait_ms(100);
        }

        //testprograms from here on

        timer.start();

        while(1) {
            // time fast forward
            for (int h=0; h<=23; h++) {
                for (int m=0; m<=59; m++) {
                    for (int s=0; s<=59; s++) {
                        clock.display_time(h,m,s);
                        wait_ms(5);
                    }
                }
            }

            // all words
            for (int i=1; i<=NUMWORDS; i++) {
                clock.test_display(3,i);
                wait_ms(800);
            }
            //all leds on with rainbow colors
            while ( int(timer.read()/10.0) %2 == 0) {
                clock.test_display(1);
                wait_ms(100);
            }
            // every led on for 250ms
            for (int i=0; i<NUMLEDS; i++) {
                clock.test_display(2,i);
                wait_ms(250);
            }
            timer.reset();
        }
    }

}
