//#include "stdio.h"
#include "mbed.h"
//#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
//#include "Terminal6x8.h"
#include "Arial43x48_numb.h"
#include "pict.h"
#include "pavement_48x34.h"

//#include "IST3020.h"
//#include "UC1608.h"
//#include "ST7565.h"
#include "ST7920.h"
//#include "ILI932x.h"
//#include "ILI9341.h"
//#include "ILI9486.h"
//#include "TFT_MIPI.h"
//#include "SSD1306.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);


//IST3020 myLCD(PAR_8, Port2, p23, p24, p25, p26, p27,"myLCD", 192, 64); // Parallel 8bit, Port, CS, reset, A0, WR, RD for F302
//zeigt Schrott an
//UC1608 myLCD(SPI_16, 10000000, p11, p12, p13, NC, NC, p16,"myLCD", 132, 64); // Spi 16bit, 10MHz, mosi, miso, sclk, cs, reset, dc

//ST7565 myLCD(PAR_8, PortC, PC_8, PC_9, PA_0, PA_1, PA_4,"myLCD", 128, 64); // Parallel 8bit, Port, CS, reset, A0, WR, RD
//ILI932x myLCD(PAR_8, PortC, PH_0, PH_1, PA_0, PA_1, PA_4,"myLCD"); // Parallel 8bit, Port, CS, reset, RS, WR, RD for F401
//ILI932x myLCD(SPI_16, 10000000, p11, p12, p13, p14, p15,"myLCD"); // Spi 16bit, 12MHz, mosi, miso, sclk, cs, reset
//ILI9341 myLCD(SPI_16, 12000000, D11, D12, D13, D10, D9, D8,"myLCD"); // Spi 16bit, 12MHz, mosi, miso, sclk, cs, reset, dc
//ILI9341 myLCD(PAR_16, PortC, PH_0, PH_1, PA_0, PA_1, PA_4,"myLCD"); // Parallel 16bit, Port, CS, reset, DC, WR, RD for F401
//ILI9486 myLCD(PAR_16, PortC, PH_0, PH_1, PA_0, PA_1, PA_4,"myLCD"); // Parallel 16bit, Port, CS, reset, DC, WR, RD for F401
//TFT_MIPI myLCD(PAR_16, PortC, PH_0, PH_1, PA_0, PA_1, PA_4,"myLCD"); // Parallel 16bit, Port, CS, reset, DC, WR, RD for F401
//SSD1306 myLCD(SPI_16, 10000000, D11, D12, D13, D10, D9, D8,"myLCD", 240, 120); // Spi 16bit, 10MHz, mosi, miso, sclk, cs, reset, dc
//zeigt Schrott an
//ILI9486 myLCD(SPI_8, 12000000, p11, p12, p13, p14, p15, p16,"myLCD"); // Spi 16bit, 12MHz, mosi, miso, sclk, cs, reset, dc for minimaple
//ILI9341 myLCD(SPI_8, 12000000, PA_7, PA_6, PA_5, PB_6, PA_8, PA_9,"myLCD"); // Spi 16bit, 12MHz, mosi, miso, sclk, cs, reset, dc for minimaple

// cs, reset,dc must not be NC!
// ST7920 can go up to 2,5MHz SPI-clock according to datasheet.Mine works with 10MHz fine too...
ST7920 myLCD(SPI_8, 10000000, p11, p12, p13, p15, p14, p16, "128x64-ST7920", 128, 64); //Spi 8bit, 1MHz, mosi, miso, sclk, cs, reset, dc

Timer t;

unsigned short backgroundcolor=White;
unsigned short foregroundcolor=Black;
//unsigned short backgroundcolor=Black;
//unsigned short foregroundcolor=White;

char orient=1;
int main()
{
//    myLCD.set_contrast(26);//for uc1608
 //   myLCD.set_contrast(46);//for ist3020
    led1=1;
    pc.baud(115200);
    pc.printf("\n\r\n\r\n\r");
    pc.printf("\n\rConnected to mbed\n\r");
    pc.printf("\n\nSystem Core Clock = %.3f MHZ\r\n",(float)SystemCoreClock/1000000);
    
    //myLCD.set_orientation(orient);
    int time, time2;
    t.start();
 //   myLCD.set_font((unsigned char*) Terminal6x8);
   // myLCD.claim(stdout);      // send stdout to the LCD display
    //myLCD.claim(stderr);      // send stderr to the LCD display
    myLCD.background(backgroundcolor);    // set background to black
    myLCD.foreground(foregroundcolor);    // set chars to white
    led1=1;
    while(1)
    {
    pc.printf("Orientation: %d\r\n",orient%4);
    myLCD.set_orientation((orient++)%4);
    
    
    pc.printf("cls() ...\r\n");
    myLCD.cls();
    wait(1);
    
    pc.printf("fillrect(0, 0, 127 , 63, black) ...\r\n");
    myLCD.fillrect(0, 0, 127 , 63, Black);
    wait(5);
    
    pc.printf("Pixels at corners...\n\r");
    myLCD.cls();
    myLCD.pixel(1,1,Black);
    myLCD.pixel(126,62,Black);
    myLCD.pixel(1,62,Black);
    myLCD.pixel(126,1,Black);
    myLCD.copy_to_lcd();
    wait(5);
    
    myLCD.cls();                // clear the screen
    myLCD.locate(0,30);
    
    myLCD.printf("Display ID: %.8X\r\n", myLCD.tftID);
    pc.printf("Display ID: %.8X\r\n", myLCD.tftID);
    // mem write/read test
    myLCD.printf("Dimension: %dX%d\r\n",myLCD.width(),myLCD.height());
    
    unsigned short readback;
    unsigned short colorstep = (0x10000/myLCD.width());
    for(unsigned short i=0; i<myLCD.width(); i++)
    {
        myLCD.pixel(i,0,i*colorstep); // write line
    }
    myLCD.copy_to_lcd();
    bool readerror=false;
    for(unsigned short i=0; i<myLCD.width(); i++) // verify line
    {
        readback = myLCD.pixelread(i,0);
        if(readback!=i*colorstep)
        {
            readerror=true;
            pc.printf("pix %.4X readback %.4X\r\n", i*colorstep, readback);
        }
    }
    myLCD.locate(0,10);
    myLCD.printf("pixelread test %s\r\n", readerror ? "FAIL":"PASS");
    wait(2);
    led2=1;
    myLCD.cls();
    myLCD.set_auto_up(false);
    myLCD.set_font((unsigned char*) Terminal6x8,32,127,false); //variable width disabled
    myLCD.locate(0,0);
    myLCD.printf("Display Test\r\nSome text just to see if auto carriage return works correctly");
    myLCD.set_font((unsigned char*) Terminal6x8);
 //   myLCD.locate(0,0);
    myLCD.printf("\r\nDisplay Test\r\nSome text just to see if auto carriage return works correctly");
    pc.printf("  Display Test \r\n");
    myLCD.set_auto_up(true);
    wait(3);
    led1=0;
    t.reset();
    myLCD.cls();
    time=t.read_us();
    myLCD.locate(2,55);
    myLCD.printf("cls: %.3fms", (float)time/1000);
    pc.printf("cls: %.3fms\r\n", (float)time/1000);
    wait(3);

    myLCD.cls();
    myLCD.set_auto_up(false);
    t.reset();
    // draw some graphics
    //myLCD.cls();
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(10,10);
    myLCD.printf("Test");

    myLCD.line(0,0,myLCD.width()-1,0,foregroundcolor);
    myLCD.line(0,0,0,myLCD.height()-1,foregroundcolor);
    myLCD.line(0,0,myLCD.width()-1,myLCD.height()-1,foregroundcolor);

    myLCD.rect(10,30,50,40,foregroundcolor);
    myLCD.fillrect(60,30,100,40,foregroundcolor);

    myLCD.circle(150,32,30,foregroundcolor);
    myLCD.fillcircle(140,20,10,foregroundcolor);

    double s;

    for (unsigned short i=0; i<myLCD.width(); i++)
        {
        s =10 * sin((long double) i / 10 );
        myLCD.pixel(i,40 + (int)s ,foregroundcolor);
        }


    time=t.read_us();
    myLCD.locate(2,55);
    myLCD.set_font((unsigned char*) Terminal6x8);
    myLCD.printf("plot: %.3fms", (float)time/1000);
    pc.printf("plot: %.3fms\r\n", (float)time/1000);
    myLCD.set_auto_up(true);
    wait(3);
    myLCD.cls();
    myLCD.set_auto_up(false);
    t.reset();
    Bitmap_s pic = {
    64, // XSize
    64, // YSize
    8, // Bytes in Line
    burp,  // Pointer to picture data 
    };
    myLCD.Bitmap_BW(pic,myLCD.width()-64,0);
    time=t.read_us();
    myLCD.locate(2,55);
    myLCD.printf("bmp: %.3fms", (float)time/1000);
    pc.printf("bmp: %.3fms\r\n", (float)time/1000);
    myLCD.set_auto_up(true);
    wait(3);
    myLCD.cls();
    myLCD.set_auto_up(false);
    myLCD.set_font((unsigned char*) Arial43x48_numb, 46, 58, false); //only numbers, variable-width disabled
    t.reset();
    myLCD.locate(0,0);
    myLCD.printf("%d", 12345);
    time=t.read_us();
    myLCD.locate(2,55);
    myLCD.set_font((unsigned char*) Terminal6x8);
    myLCD.printf("Big Font: %.3fms", (float)time/1000);
    pc.printf("Big Font: %.3fms\r\n", (float)time/1000);
    myLCD.set_auto_up(true);
    wait(3);
    // sparse pixels test
    myLCD.cls();
    myLCD.FastWindow(true);
    t.reset();
    for(unsigned int i=0; i<20000; i++)
    {
        myLCD.pixel((i+(i*89)%myLCD.width()), (i+(i*61)%myLCD.height()), White);
    }
    myLCD.copy_to_lcd();
    time=t.read_us();
    myLCD.cls();
    myLCD.FastWindow(false);
    t.reset();
    for(unsigned int i=0; i<20000; i++)
    {
        myLCD.pixel((i+(i*89)%myLCD.width()), (i+(i*61)%myLCD.height()), White);
    }
    myLCD.copy_to_lcd();
    time2=t.read_us();
    myLCD.locate(2,55);
    myLCD.printf("std:%.3fms fastw:%.3fms", (float)time2/1000, (float)time/1000);
    pc.printf("std: %.3fms fastw: %.3fms\r\n", (float)time2/1000, (float)time/1000);
    wait(3);
    // scroll test, only for TFT
    myLCD.cls();
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(2,10);
    myLCD.printf("Scrolling");
    myLCD.rect(0,0,myLCD.width()-1,myLCD.height()-1,White);
    myLCD.rect(1,1,myLCD.width()-2,myLCD.height()-2,Blue);
    myLCD.setscrollarea(0,myLCD.sizeY());
    wait(1);
    myLCD.scroll(1); //up 1
    wait(1);
    myLCD.scroll(0); //center
    wait(1);
    myLCD.scroll(myLCD.sizeY()-1); //down 1
    wait(1);
    myLCD.scroll(myLCD.sizeY()); // same as 0, center
    wait(1);
    myLCD.scroll(myLCD.sizeY()>>1); // half screen
    wait(1);
    myLCD.scrollreset(); // center
    wait(1);
    for(unsigned short i=1; i<=myLCD.sizeY(); i++)
    {
        myLCD.scroll(i);
        wait_ms(2);
    }
    wait(2);
    // color inversion
    for(unsigned short i=0; i<=8; i++)
    {
        myLCD.invert(i&1);
        wait_ms(200);
    }
    wait(2);
    // bmp 16bit test
    myLCD.cls();
    t.reset();
    for(int y=0; y<myLCD.height(); y+=34)
    {
        for(int x=0; x<myLCD.width(); x+=48) myLCD.Bitmap(x,y,48,34,(unsigned char *)pavement_48x34);
    }
    time=t.read_us();
    myLCD.locate(2,55);
    myLCD.set_font((unsigned char*) Terminal6x8);
    myLCD.printf("Bmp speed: %.3fms", (float)time/1000);
    pc.printf("Bmp speed: %.3fms\r\n", (float)time/1000);
    wait(2);
    }
}