#include <string.h>
#include "TextLCDScroll.h"
#include "mbed.h"

TextLCDScroll::TextLCDScroll(PinName rs, PinName e, PinName d4, PinName d5,
                             PinName d6, PinName d7, TextLCD::LCDType type): TextLCD(rs,e,d4,d5,d6,d7,type)
{

    _direction = new int[rows()];
    _actPos = new int[rows()];

    //_mode = leftright;
    _mode = left;

    //set Speed and start Ticker
    setSpeed(5);
    
    cls();

    // reduce interrupt level for the ticker timers. so other things (RF22 ) come first
    //NVIC_SetPriority(TIMER3_IRQn, 10);

}

void TextLCDScroll::cls()
{
    for (int i=0; i<rows(); i++) {
        _direction[i]=1;
        _actPos[i] = 0;
        setLine(i,"");
        TextLCD::cls();
    }
}

bool TextLCDScroll::setLine( int Line, char  *str)
{
    if (Line >= 0 && Line < rows()) {
        //stop interrupts
        tick.detach();
        // free the old memory
        //if (line[Line] != NULL) {
        //    free(line[Line]);
        //}
        // malloc new space for string
        //line[Line] = (char*)malloc((strlen(str)+1)*sizeof(char));
        //Realocate memory
        line[Line] = (char*)realloc(line[Line], (strlen(str)+1)*sizeof(char));
        //copy the string
        strcpy(line[Line], str);
        // be sure to refresh the display
        TextLCD::cls();
        // start at beginning again
        _actPos[Line] = 0;
        _direction[Line] =1;
        startTicker();
        return(true);
    } else {
        return (false);
    }
}

void TextLCDScroll::startTicker(){
        if (_mode == leftright)
            tick.attach(this,&TextLCDScroll::ScrollRightLeft, 1.0/_speed);
        else
            tick.attach(this,&TextLCDScroll::ScrollLeft, 1.0/_speed);
}

bool TextLCDScroll::setSpeed( int speed)
{
    if ((speed >= 0.1) && (speed <= 10)) {
        tick.detach();
        _speed = speed;
        startTicker();
        return(true);
    } else {
        return(false);
    }
}

bool TextLCDScroll::setScrollMode( ScrollModes mode)
{
    _mode = mode;
    return(true);
}

void TextLCDScroll::ScrollRightLeft()
{
    int i, j;
    //all rows
    for (i=0; i<rows(); i++) {
        // all columns
        for (j=0; j<columns(); j++) {

            locate(j,i);
            // is string shorter than width of display
            if (strlen(line[i]) <= columns()) {
                if (j < strlen(line[i])) {
                    putc(line[i][j]);
                } else {
                    putc(' ');
                }
            } else { // sting is longer -> scroll
                if ((_actPos[i]+j < columns()) || (_actPos[i]+j >= columns()+strlen(line[i]))) {
                    putc(' ');
                } else {
                    putc(line[i][_actPos[i]-columns()+j]);
                }
            }
        }
        // shift start-position of string
        // left = ++
        if (_direction[i] == 1) {
            if (_actPos[i] < (strlen(line[i])+(columns()))) {
                _actPos[i]++;
            } else {
                _direction[i] = 0; // reverse direction
                _actPos[i]--;
            }
        } else { //right = --
            if (_actPos[i] > 1 ) {
                _actPos[i]--;
            } else {
                _direction[i] = 1; // reverse direction
                _actPos[i]++;
            }
        }

    }

}

void TextLCDScroll::ScrollLeft()
{
    int i, j;
    //all rows
    for (i=0; i<rows(); i++) {
        // all columns
        for (j=0; j<columns(); j++) {

            locate(j,i);
            // is string shorter than width of display
            if (strlen(line[i]) <= columns()) {
                if (j < strlen(line[i])) {
                    putc(line[i][j]);
                } else {
                    putc(' ');
                }
            } else { // sting is longer -> scroll
                if ((_actPos[i]+j < columns()) || (_actPos[i]+j >= columns()+strlen(line[i]))) {
                    putc(' ');
                } else {
                    putc(line[i][_actPos[i]-columns()+j]);
                }
            }
        }
        // shift start-position of string
        if (_actPos[i] < (strlen(line[i])+(columns()))) {
            _actPos[i]++;
        } else {
            _actPos[i]=0;
        }
    }

}
