// Testprogramm for RFM22B with RF22Max-Library to read ELV MAX! window Shutter-Contacts and PushBottons

//show debug output on Serial pc
#define DEBUG

#include "mbed.h"
#include <RF22Max.h>
#include "TextLCDScroll.h"

// show debug-output on console
//#define DEBUG

Serial pc(USBTX, USBRX);

Ticker SendTicker;

volatile int doSend = 0;     // set to 1 by Ticker-Interrupt and read in main-loop

TextLCDScroll lcd(p30, p29, p28, p27, p26, p25, TextLCD::LCD16x2); // rs, e, d4-d7

// mbed LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Singleton instance of the radio
//rf22(PinName slaveSelectPin , PinName mosi, PinName miso, PinName sclk, PinName interrupt );
RF22Max rf22(p14,p11,p12,p13,p15);

void Ticker_isr()
{
    led1 = !led1;
    doSend = 1;
}


int main()
{


    char lcdline[500];

    RF22Max::max_message MyMessage;
    int  i;

    uint8_t sbuf[RF22_MAX_MESSAGE_LEN];

    uint8_t slen = sizeof(sbuf);

    pc.baud(115200);

    pc.printf("\n\rConnected to mbed\n\r");


    char version_str [80] = "RF22-Send-Test!-V1.0";
    lcd.cls();
    lcd.setLine(0,version_str);
    pc.printf("%s\n\r",version_str);


    pc.printf("Pre-init|");
    if (!rf22.init())
        pc.printf("RF22Max init failed\n\r");
    pc.printf("Post-init\n\r");


    rf22.setModeRx();


    SendTicker.attach(&Ticker_isr, 5.0); // Send every 5 seconds

    //wait forever and see what comes in
    while (1) {

        // did we get a MAX!-Message?
        if (rf22.recv_max(&MyMessage)) {
            // we got a message
            led2 = !led2;
            sprintf(lcdline,"Got Message type: %s Msg-Nr:%i from Device-ID:%06X State:%s Battery %s", MyMessage.type_str,MyMessage.cnt, MyMessage.frm_adr, MyMessage.state, MyMessage.battery_state);
            pc.printf("%s\n\r",lcdline);
            lcd.setLine(0,lcdline);

        }

        if (doSend) {
            //we should send something
            doSend = 0;
            led4=1;
            // try to send a simulated window-shutterContact-message
            // wait some time
            sbuf[0] = 11; // MsgLen
            sbuf[1] = 0x21; // MsgCount ??
            sbuf[2] = 0x00; // Flag
            sbuf[3] = 0x30; // Type = Cmd = ShutterContactState
            sbuf[4] = 0x11; // From Fake Address
            sbuf[5] = 0x11; // From
            sbuf[6] = 0x11; // From
            sbuf[7] = 0x00; // To Address : broadcast
            sbuf[8] = 0x00;
            sbuf[9] = 0x00;
            sbuf[10] = 0x00; // GroupId
            sbuf[11] = 0x02;  //Payload is 0x02: State Open, Battery: good
            slen = 12+2; //+2Byte CRC????
            /* Calculate CRC */
            uint16_t scrc = rf22.calc_crc(sbuf, slen - 2);
            sbuf[12] = scrc >> 8;
            sbuf[13] = scrc & 0xff;


            if (rf22.send(sbuf,slen)) {
#ifdef DEBUG
                pc.printf("Send window-shutterContact-message OK\n\r");
#endif
            } else {
#ifdef DEBUG
                pc.printf("Send window-shutterContact-message NOT OK\n\r");
#endif
            }
            led4 = 0;

        }

    }
}


