#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "MenuItem.h"
#include <vector>

class MenuItem;

/** Menu: Create Menues with Submenues, MenuItems, actions,...
*
*/
class Menu {
    private:
    public:
        /** vector of of Menu-Items
        *
        */
        vector<MenuItem> selections;
        
        /** name of a menu
        */
        char *menuID;

        // currently selected Item in Menu (used to return to this point from submenu)
        int  CurrentSelection;       
        
        /** a menu
        */
        Menu(char *);
        
        /** add an Item to the menu
        */
        void add(const MenuItem &toAdd);
        /** change the text of an menu-item
        */
        void changeText(int position, char *newText);
        /** get current text of menu-item
        */
        char *getText(int);
};
#endif