#ifndef MENUITEM_H
#define MENUITEM_H

#include "Menu.h"

class Menu; 

/** MenuItem is a menu-item of menu
*/
class MenuItem {
    private:
        
    public:
        /** modes of MenuItems
        */
        enum mode{
            /** default mode: just display the Menu-Text an perform user_action
            */
            mode_default = 0,
            
            /** wait_select: Call user_action and then only accept a select
            * use for displaying text, values,...
            * the menu is paused until select is pressed
            */
            mode_wait_select = 1,
            
            /** mode_yes_no: show text and ask user for yes/no
            * 
            */
            mode_yes_no = 2,
            
            //** mode_long_text: show a long text with scrollbars and wait for select()
            mode_show_longtext = 3
            };
         
        /** structure to pass data to menu and back
        */
        struct menu_data{
            // Longer text to display.
            // For Yes/No-Question
            // or show_longtext
            char * text;
            //Yes/No Value In and Out
            bool yes_no;
        };   
    
        /** pointer to user-action to execute when menu item is selected
        */
        void (*userAction)();   
        /** Text of Menue-Item to display
        */
        char* selText;   
        /** position of menuitem in menu
        */
        int pos;         
        /** Pointer to child-menue
        */
        Menu *childMenu; 
        /** itemMode
        */
        uint8_t itemMode;
        
        menu_data * menu_parameter;
        
        /** a sub-menu
        */
        MenuItem(void (*)(), int, Menu *, char *, uint8_t = mode_default, menu_data * = NULL); 
         
};

#endif 