#include "mbed.h"
#include "EthernetInterface.h"
#include "PubSubClient.h"

Serial pc(USBTX, USBRX);

char* serverIpAddr = "192.168.2.111";  /*Sever ip address*/
int port = 1883; /*Sever Port*/

void callback(char* topic, char* payload, unsigned int len); /*Callback function prototype*/
PubSubClient mqtt(serverIpAddr, port, callback);
EthernetInterface  eth;

void callback(char* topic, char* payload, unsigned int len)
{
    //Send incoming payloads back to topic "/mbed".
    mqtt.publish("mbed", payload, len);
}

int main() {

    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    pc.printf("MQTTClient Tester");
    
    
    char clientID[] = "mbed";   /*Client nanme show for MQTT server*/
    char pub_topic[] = "mbed";   /*Publish to topic : "/mbed" */
    char sub_topic[] = "mirror";   /*Subscribe to topic : "/mirror" */
    
    if(!mqtt.connect(clientID)){
        pc.printf("\r\nConnect to server failed ..\r\n");
        return -1;
    }
    
    pc.printf("\r\nConnect to server sucessed ..\r\n");
    
    mqtt.publish(pub_topic, "Hello here is mbed...");
    mqtt.subscribe(sub_topic);
       
    
   pc.printf("#### End of the test.. ####");
      
   //eth.disconnect();
    
    while(1) {
    mqtt.loop();
    }
}