/* Code for manual controls of Smart Auto Car using Bluetooth  */
#include "mbed.h"
//#include "Map.hpp"

#include "Servo.h"// The desired Servo sweep range is 60 degrees
// But due to some mechanical Load errors it has been calibrated to 0 to 70 degrees
// The front facing position varies from 27 degress to 38 degrees due to the servo motion slip.

// Variable declaration
Servo myservo(D3);// Object to declare the servo functionalities
int pos = 33;// Default avg front facing posiion of the Servo
int i;
int j;
int i1;
int j1;

int Flg=0; // Flag to enable motions (Forward, Backward, Stop state)
int FlgSt = 0;// Unused Variable
float Level = 0.30;// Variable to store the PWM Levels activated by the gear Button in the App.
float pwm_Level;// Unused Variable
// Function Initialisation
void handleInput(int in); 
void drive_forward(float level);
void drive_backward(float level);
void Robot_Stop();

Serial pc(USBTX,USBRX);//Tx Rx for Serial Communication (UART)(PC to Processor)
Serial BT(PTC15,PTC14);// Tx Rx for Bluetooth Communication () 

PwmOut ENApwm(D5); // Motor driver Enable A
PwmOut ENBpwm(D6); // Motor driver Enable B

// Setting coresponding pins to output mode for Motor movements
DigitalOut LeftMotor_P1(D8);
DigitalOut LeftMotor_P2(D9);
DigitalOut RightMotor_P1(D11);
DigitalOut RightMotor_P2(D10);


// The main Function 
int main() {
    pc.baud(9600);// UART communication in 9600 bits per seconds
    BT.baud(9600);// Bluetooth communication in 9600 bits per seconds
    // Printing some execution statements to ensure the controller is communicating properly.
    pc.printf(" Hello User!\r\n");
    printf(" Are You Ready \r\n");    
   // At the start set servo to its default front facing  position 
    if(pos>33){
        myservo = (27/100.0);
    }
    else{
         myservo = (38/100.0);        
    }
        
   
    while(1){ // run an infinite loop to read blutooth data & call corresponding navigation function
        if (BT.readable()){ // Read incoming Bluetooth Data
         int BT_Val = (int)(pc.putc(BT.getc()));// get the Ascii value of the incomming 1 byte data
           //int i = atoi((int)BT_Val);        // Convert it to Interger.
           //BT_Val -='0';
           pc.printf("%d \r\n",BT_Val); // print the Bluetooth data in serial Monitor for cross validation
           // Bluetooth data below decimal 25 contains certain values for the button operations 
           // Bluetooth data above 25 triggers the PWM pins of EnA and EnB for motor speed control
          
           if (BT_Val >= 25 && BT_Val <=100){
               Level = ((float)BT_Val/100);               
               pc.printf("%f \r\n",Level);
               //float pwm_Level = Level;
               }
           else if (BT_Val < 25){
                handleInput(BT_Val);
               }
           if (Flg == 1){
                drive_forward((float)Level);                
            }
           else if (Flg == 2){
                drive_backward((float)Level);
            } 
           else if (Flg == 0){
                Robot_Stop();
            } 
                                    
        //if BT_Val == 'B'               
        }
    }
}  
    
// Function which calls specific execution for corresponding incomming Serial inputs from Bluetooth

void handleInput(int in) {
    switch(in) { 
    //Motor Rotation Controls       
        case 6 :// Forward Motion
            Flg = 1;
            break;        
        case 7 :
            Flg = 2;// Backward Motion
            break;
        case 0 :  // Robot Stop      
            Flg = 0;
            break;
    //Servo Rotation Controls
        case 1:// Turn 30 degree Left and back to front facing
            if (pos >0){
                myservo = (pos/100.0);
                for( j1=pos; j1>=0; j1--) {
                    myservo = (j1/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);        
                }
                pos=j1;
                for(i1=pos; i1<=38; i1++) {
                    myservo = (i1/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);
                }
                pos=i1;         
            }
            else{
                 myservo = (0/100.0); 
                 pos = 0;
                 for(i1=pos; i1<=38; i1++) {
                    myservo = (i1/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);
                }
                pos=i1;                
            }                
            break;
            
        case 2: //Turn 30 degree Left 
            if (pos >0){
                //myservo = (pos/100.0);
                for( j1=pos; j1>=0; j1--) {
                    myservo = (j1/100.0);
                   // printf("%f\r\n",myservo.read());
                    wait(0.01);        
                }
                pos=j1;         
            }
            else{
                 myservo = (0/100.0);                
            }      
            break;
            
        case 3: // Sweep Servo to forward position irrespective of its current position
            if(pos >40){
                //myservo = (pos/100.0);
                for( j=pos; j>=27; j--) {
                    myservo = (j/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);        
                }
                pos=j;
                
            }
            else if (pos < 25){
                //myservo = (pos/100.0);
                for(i1=pos; i1<=38; i1++) {
                    myservo = (i1/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);
                }
                pos=i1;   
                
            }
            else{
                myservo = (pos/100.0);                
            }
            break;
            
        case 4://Turn 30 degree Right
            if (pos <70){
               // myservo = (pos/100.0);
                for(i=pos; i<=70; i++) {
                    myservo = (i/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);
                }
                pos=i;                
            }
            else{
                myservo = (70/100.0);                 
            }
            break;
            
        case 5:// Turn 30 degree Right and back to front facing
            if (pos <70){
                //myservo = (pos/100.0);
                for(i=pos; i<=70; i++) {
                    myservo = (i/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);
                }
                pos=i; 
                for( j=pos; j>=27; j--) {
                    myservo = (j/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);        
                }
                pos=j;               
            }
            else{
                myservo = (70/100.0);
                pos = 70;
                for( j=pos; j>=27; j--) {
                    myservo = (j/100.0);
                    //printf("%f\r\n",myservo.read());
                    wait(0.01);        
                }
                pos=j;                 
            }
            //break;
            break;
            
        case 8:// Turn Servo Left by 5 degrees irrespective of its current position
            pos = pos-5;
            myservo = (pos/100.0);
            if (pos < 0){
                pos = 0;                
            }   
            break;
            
        case 9: // Turn Servo right by 5 degrees irrespective of its current position
            pos = pos+5;
            myservo = (pos/100.0); 
            if (pos > 70){
                pos = 70;                
            }            
            break; 
        
        default:
            pc.printf("I don't know: \"%d\"\n", in);
            break;
    }
}

// Function to move rear wheel DC motors forward

void drive_forward(float level){
     ENApwm.write(level);
     ENBpwm.write(level); 
     LeftMotor_P1=1; 
     LeftMotor_P2=0;
     RightMotor_P1=1;
     RightMotor_P2=0; 
} 

// Function to move rear wheel DC motors backward 
void drive_backward(float level){
     ENApwm.write(level);
     ENBpwm.write(level); 
     LeftMotor_P1=0; 
     LeftMotor_P2=1;
     RightMotor_P1=0;
     RightMotor_P2=1; 
 } 
 

// Function to stop rear wheel motion
void Robot_Stop() {
     //ENApwm.write(level);
     //ENBpwm.write(level); 
     LeftMotor_P1=1; 
     LeftMotor_P2=1;
     RightMotor_P1=1;
     RightMotor_P2=1; 
} 