/* Define to prevent from recursive inclusion --------------------------------*/
#ifndef __DEV_53L1X_I2C_H
#define __DEV_53L1X_I2C_H

/* Includes ------------------------------------------------------------------*/

#include "mbed.h"

#include "pinmap.h"

static int mutex =0;

//Class replacing DevI2C class as it was not implementing a 16bit address registers   
class vl6180_DevI2C : public I2C
{
public:
    /** Create a DevI2C Master interface, connected to the specified pins
     *
     *  @param sda I2C data line pin
     *  @param scl I2C clock line pin
     */
    vl6180_DevI2C(PinName sda, PinName scl) : I2C(sda, scl) { printf ("hello\n");}
    

    // write to the sensor over 12c. The stmpe1600 requires the function below because it uses 1 register byte rather than 2.
        int vl6180_i2c_write(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToWrite) {
        int ret;
        uint8_t tmp[TEMP_BUF_SIZE];
        
        if(NumByteToWrite >= TEMP_BUF_SIZE) return -2;
                        
 //   printf("sss %d %d %d %d %d \n",DeviceAddr,RegisterAddr,NumByteToWrite+1,pBuffer[0],pBuffer[1]);
            // First, send device address. Then, send data and STOP condition 
        tmp[0] = RegisterAddr >> 8;
        tmp[1] = RegisterAddr & 0x0FF;
        memcpy(tmp+2, pBuffer, NumByteToWrite);

        ret = write(DeviceAddr, (const char*)tmp, NumByteToWrite+2, false);

        if(ret){
           printf("rrr%d %d %d %d %d %d %d %d\n",DeviceAddr,RegisterAddr,NumByteToWrite+1,tmp[0],tmp[1],tmp[2],tmp[3],ret);
           return -1;
         }
        
        return 0;
    }
    
   
        // write to the stmpe1600 over 12c. The sensor requires the function above because it uses 2 register bytes rather than 1.
    int vl6180_i2c_write_stmpe(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                               uint16_t NumByteToWrite) {
        int ret;
        uint8_t tmp[TEMP_BUF_SIZE];
        
        if(NumByteToWrite >= TEMP_BUF_SIZE) return -2;
        
                      // First, send device address. Then, send data and STOP condition 
        tmp[0] = RegisterAddr;
        memcpy(tmp+1, pBuffer, NumByteToWrite);

        ret = write(DeviceAddr, (const char*)tmp, NumByteToWrite+1, false);
        if(ret){
    //       printf("www%d %d %d %d %d %d %d %d\n",DeviceAddr,RegisterAddr,NumByteToWrite+1,tmp[0],tmp[1],tmp[2],tmp[3],ret);
           return -1;
         }
            
        

        return 0;
    }


    /**
     * @brief  Reads a buffer from the I2C peripheral device.
     * @param  pBuffer pointer to the byte-array to read data in to
     * @param  DeviceAddr specifies the peripheral device slave address.
     * @param  RegisterAddr specifies the internal address register
     *         where to start reading from (must be correctly masked).
     * @param  NumByteToRead number of bytes to be read.
     * @retval 0 if ok,
     * @retval -1 if an I2C error has occured
     * @note   On some devices if NumByteToWrite is greater
     *         than one, the RegisterAddr must be masked correctly!
     */
    int vl6180_i2c_read(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                 uint16_t NumByteToRead) {
        int ret;
        uint8_t ExpanderData[2];
        ExpanderData[0] = RegisterAddr >> 8;
        ExpanderData[1] = RegisterAddr & 0x0FF;
        /* Send device address, with no STOP condition */
        ret = write(DeviceAddr, (const char*)ExpanderData, 2, true);
        if(!ret) {
            /* Read data, with STOP condition  */
            ret = read(DeviceAddr, (char*)pBuffer, NumByteToRead, false);
        }

        if(ret) return -1;
        return 0;
    }
    
    
    int vl6180_i2c_read_stmpe(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                 uint16_t NumByteToRead) {
        int ret;
        uint8_t ExpanderData[2];
        ExpanderData[0] = (uint8_t)RegisterAddr;
        /* Send device address, with no STOP condition */
        ret = write(DeviceAddr, (const char*)ExpanderData, 1, true);
        if(!ret) {
            /* Read data, with STOP condition  */
            ret = read(DeviceAddr, (char*)pBuffer, NumByteToRead, false);
        }

        if(ret) return -1;
        return 0;
    }

private:
    static const unsigned int TEMP_BUF_SIZE = 256;
};

#endif /* __DEV_53L1X_I2C_H */