/**
 ******************************************************************************
 * @file    vl6180_class.cpp
 * @author  JS
 * @version V0.0.1
 * @date    15-January-2019
 * @brief   Implementation file for the VL53L1 sensor component driver class
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2018 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include <stdlib.h>
#include "vl6180_class.h"
#include "vl6180_i2c_fn.h"
#include "vl6180_def.h"
#include "vl6180_api.h"


#define ALGO__PART_TO_PART_RANGE_OFFSET_MM  0x001E
#define MM_CONFIG__INNER_OFFSET_MM          0x0020
#define MM_CONFIG__OUTER_OFFSET_MM          0x0022

//#include "vl53l1x_configuration.h"


#ifndef MIN
#define MIN(v1, v2) ((v1) < (v2) ? (v1) : (v2))
#endif
#ifndef MAX
#define MAX(v1, v2) ((v1) < (v2) ? (v2) : (v1))
#endif

#define DMAX_REFLECTANCE_IDX 2

#define LOWPOWER_AUTO_VHV_LOOP_DURATION_US 245
#define LOWPOWER_AUTO_OVERHEAD_BEFORE_A_RANGING 1448
#define LOWPOWER_AUTO_OVERHEAD_BETWEEN_A_B_RANGING 2100

#define FDA_MAX_TIMING_BUDGET_US 550000

#define VL53L1DevStructGetLLDriverHandle(Dev) (&Dev->Data.LLData)


VL6180_ERROR VL6180::vl6180_GetSWVersion(VL6180_Version_t *pVersion)
{
    VL6180_ERROR Status = 0;

    pVersion->major = VL53L1X_IMPLEMENTATION_VER_MAJOR;
    pVersion->minor = VL53L1X_IMPLEMENTATION_VER_MINOR;
    pVersion->build = VL53L1X_IMPLEMENTATION_VER_SUB;
    pVersion->revision = VL53L1X_IMPLEMENTATION_VER_REVISION;
    return Status;
}

VL6180_ERROR VL6180::vl6180_SetI2CAddress(uint8_t new_address)
{
    VL6180_ERROR status = 0;

   // Device.i2c_addr = new_address;  
    
    if ( Device.i2c_addr != new_address)
    {

        status = VL6180_SetI2CAddress (&Device,new_address);
        printf("VL53L1X_SetI2CAddress %d to %d \n", Device.i2c_addr,new_address);
        Device.i2c_addr = new_address; 

    }
            printf("Sensor right VL53L1X_SetI2CAddress end\n\r");
    return status;
}

int VL6180::init_sensor(uint8_t new_addr)
{
    Device.i2c_addr = new_addr;
    int status = 0;
    VL53L1_Off();
    VL53L1_On();

    status = is_present();
    if (!status) {
        printf("Failed to init VL53L0X sensor!\n\r");
        return status;
    }
    printf("init_sensor %d \n",status);
    return status;
}


VL6180_ERROR VL6180::vl6180_ClearInterrupt()
{
    VL6180_ERROR status = 0;

    //status = VL53L1_WrByte(Device, SYSTEM__INTERRUPT_CLEAR, 0x01);
    status = VL6180_ClearInterrupt(&Device, INTERRUPT_CLEAR_ERROR|INTERRUPT_CLEAR_RANGING);
    printf("VL6180::VL53L1X_ClearInterrupt()\n");
    return status;
}


VL6180_ERROR VL6180::vl6180_WaitDeviceBooted(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_WaitDeviceBooted(dev);

    return status;
}

VL6180_ERROR VL6180::vl6180_InitData(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_InitData(dev);

    return status;
}


VL6180_ERROR VL6180::vl6180_DMaxSetState(VL6180Dev_t dev, int state)
{
    VL6180_ERROR status = 0;
    status = VL6180_DMaxSetState(dev,state);

    return status;
}

VL6180_ERROR VL6180::vl6180_UpscaleGetScaling(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_UpscaleGetScaling(dev);

    return status;
}

VL6180_ERROR VL6180::vl6180_FilterGetState(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_FilterGetState(dev);

    return status;
}



// required?
VL6180_ERROR VL6180::vl6180_SetInterruptPolarity(uint8_t NewPolarity)
{
  //  uint8_t Temp;
    VL6180_ERROR status = 0;

 //   status = VL53L1_RdByte(Device, GPIO_HV_MUX__CTRL, &Temp);
//    Temp = Temp & 0xEF;
//    status = VL53L1_WrByte(Device, GPIO_HV_MUX__CTRL, Temp | (!(NewPolarity & 1)) << 4);

    return status;
}

VL6180_ERROR VL6180::vl6180_Prepare(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_Prepare(dev);

    return status;
}

VL6180_ERROR VL6180::vl6180_RangePollMeasurement(VL6180Dev_t dev, VL6180_RangeData_t *pRangeData)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangePollMeasurement(dev,pRangeData);

    return status;
}

/*
VL6180_ERROR VL6180::VL6180x_AlsPollMeasurement(VL6180xDev_t dev, VL6180x_AlsData_t *pAlsData)
{
    VL6180_ERROR status = 0;
    status = VL6180x_AlsPollMeasurement(dev,pAlsData);

    return status;
}
*/


VL6180_ERROR VL6180::vl6180_GetInterruptPolarity(uint8_t *pInterruptPolarity)
{
    uint8_t Temp;
    VL6180_ERROR status = 0;

    status = VL6180_RdByte(&Device, GPIO_HV_MUX__CTRL, &Temp);
    Temp = Temp & 0x10;
    *pInterruptPolarity = !(Temp>>4);
    return status;
}

VL6180_ERROR VL6180::VL6180_I2CWrite(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t* pBuffer, uint16_t NumByteToWrite)
{
    int ret;
    ret = dev_i2c->vl6180_i2c_write(pBuffer, DeviceAddr, RegisterAddr, NumByteToWrite);
    if (ret) {
        return -1;
    }
    return 0;

}

VL6180_ERROR VL6180::VL6180_I2CRead(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t* pBuffer, uint16_t NumByteToRead)
{
    int ret;

    ret = dev_i2c->vl6180_i2c_read(pBuffer, DeviceAddr, RegisterAddr, NumByteToRead);
    //ret = dev_i2c->i2c_read(pBuffer, DeviceAddr, RegisterAddr, NumByteToRead);
    if (ret) {
        return -1;
    }
    return 0;
}

VL6180_ERROR VL6180::vl6180_RangeStartContinuousMode(VL6180Dev_t dev)

{
    VL6180_ERROR status = 0;
    status = VL6180_RangeStartContinuousMode(dev);

    return status;
}


VL6180_ERROR VL6180::vl6180_RangeStartSingleShot(VL6180Dev_t dev)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeStartSingleShot(dev);

    return status;
}


VL6180_ERROR VL6180::vl6180_RangeSetInterMeasPeriod(VL6180Dev_t dev, uint32_t  InterMeasTime_msec)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeSetInterMeasPeriod(dev,InterMeasTime_msec);

    return status;
}

VL6180_ERROR VL6180::vl6180_RangeGetMeasurement(VL6180Dev_t dev, VL6180_RangeData_t *pRangeData)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeGetMeasurement(dev,pRangeData);

    return status;
}


VL6180_ERROR VL6180::vl6180_RangeGetMeasurementIfReady(VL6180Dev_t dev, VL6180_RangeData_t *pRangeData)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeGetMeasurementIfReady(dev,pRangeData);

    return status;
}

VL6180_ERROR VL6180::vl6180_SetupGPIO1(VL6180Dev_t dev, uint8_t IntFunction, int ActiveHigh)
{
    VL6180_ERROR status = 0;
    status = VL6180_SetupGPIO1(dev,IntFunction,ActiveHigh);

    return status;
}


VL6180_ERROR VL6180::vl6180_RangeConfigInterrupt(VL6180Dev_t dev, uint8_t ConfigGpioInt)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeConfigInterrupt(dev,ConfigGpioInt);

    return status;
}

VL6180_ERROR VL6180::vl6180_ClearInterrupt(VL6180Dev_t dev, uint8_t IntClear)
{
    VL6180_ERROR status = 0;
    status = VL6180_ClearInterrupt(dev,IntClear);

    return status;
}


VL6180_ERROR VL6180::vl6180_RangeSetThresholds(VL6180Dev_t dev, uint16_t low, uint16_t high, int UseSafeParamHold)
{
    VL6180_ERROR status = 0;
    status = VL6180_RangeSetThresholds(dev,low,high,UseSafeParamHold);

    return status;
}

VL6180_ERROR VL6180::vl6180_FilterSetState(VL6180Dev_t dev, int state)
{
    VL6180_ERROR status = 0;
    status = VL6180_FilterSetState(dev,state);

    return status;
}

VL6180_ERROR VL6180::vl6180_UpscaleSetScaling(VL6180Dev_t dev, uint8_t scaling)
{
    VL6180_ERROR status = 0;
    status = VL6180_UpscaleSetScaling(dev,scaling);

    return status;
}
