#include "NoShield53L3.h"

NoShield53L3 *NoShield53L3::_instance = NULL;


NoShield53L3 *NoShield53L3::instance(vl53L3_DevI2C *ext_i2c)
{
    if (_instance == NULL) {
        _instance = new NoShield53L3(ext_i2c);
    } else {
        printf("Failed to create NoShield53l3 instance\n\r\r\n");
    }
    return _instance;
}

NoShield53L3 *NoShield53L3::instance(vl53L3_DevI2C *ext_i2c,
                                       PinName gpio1_centre,
                                       PinName gpio1_left, PinName gpio1_right)
{
    if (_instance == NULL) {
//        printf("instance %d z\n",ext_i2c);
        _instance = new NoShield53L3(ext_i2c, gpio1_centre, gpio1_left, gpio1_right);
    } else {
        printf("Failed to create XNucleo53L0A1 instance\n\r");
    }
    return _instance;
}


// no stmpe1600. Shutdown lijnes controlled from pins passed in
int NoShield53L3::init_board(PinName shut_centre,
                                       PinName shut_left, PinName shut_right)
{
    printf("init_board \n");
    int status, n_dev = 0;
    
        // set the shutdown pins to be outputs ( they are inputs on power up)
    DigitalOut sensor1shut(shut_centre);
    DigitalOut sensor2shut(shut_left);
    DigitalOut sensor3shut(shut_right);
    
    // On startup or on the shutdown pin going high the VL53l1 devices have a i2c address of 0x52.
    // To initialise then we have to bring up one device at a time This involves raising the shutdown pin for that device,
    // initialising then setting the i2c address to a unique value. Once that is done the shutdown pins don't need to be touched.

    // set the shutdown pins to low, this will reset the VL53l1
    sensor1shut =0;
    sensor2shut =0;
    sensor3shut =0;
// select the first VL53l1. It will have i2c address of 0x52. Set the i2c address to
//NEW_SENSOR_CENTRE_ADDRESS

    sensor1shut =1;
    printf("InitSensor \n");
    status = sensor_centre->InitSensor(NEW_SENSOR_CENTRE_ADDRESS);
    if (status) {
        delete sensor_centre;
        sensor_centre = NULL;
        printf("Sensor centre not present\n\r");
    } else {
        printf("Sensor centre present\n\r");
        n_dev++;
    }
    
    // select the second VL53l1. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_LEFT_ADDRESS
    sensor2shut =1;
    status = sensor_left->InitSensor(NEW_SENSOR_LEFT_ADDRESS);
    if (status) {
        delete sensor_left;
        sensor_left = NULL;
        printf("Sensor left not present\n\r");
    } else {
        printf("Sensor left present\n\r");
        n_dev++;
    }
    
     // select the 3rd VL53l1. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_RIGHT_ADDRESS 
    sensor3shut =1;
    status = sensor_right->InitSensor(NEW_SENSOR_RIGHT_ADDRESS);
    if (status) {
        delete sensor_right;
        sensor_right = NULL;
        printf("Sensor right not present\n\r");
    } else {
        printf("Sensor right present\n\r");
        n_dev++;
    }

return 0;
    if (n_dev == 0) {
        return 1;
    } else {
        return 0;
    }
}
