/**
 ******************************************************************************
 * @file    NoShield53l3.h
 * @author  JS
 * @version V0.0.1
 * @date    15-January-2019
 * @brief   Header file for component XNucleo53L1A1
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2019 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

#ifndef __VL53L1_NO_SHIELD_CLASS_H
#define __VL53L1_NO_SHIELD_CLASS_H


/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "PinNames.h"
#include "vl53l3cx_class.h"
//#include "Stmpe1600.h"
//#include "DevI2C.h"
#include "vl53L3_I2c.h"


#define NEW_SENSOR_CENTRE_ADDRESS   0x56
#define NEW_SENSOR_LEFT_ADDRESS         0x58
#define NEW_SENSOR_RIGHT_ADDRESS        0x5a


/* Classes--------------------------------------------------------------------*/

/* Classes -------------------------------------------------------------------*/
/** Class representing the X-NUCLEO-VL53L1A1 expansion board
 */
class NoShield53L3
{
public:
    /** Constructor 1
    * @param[in] &i2c device I2C to be used for communication
    */
    NoShield53L3(vl53L3_DevI2C *ext_i2c) : dev_i2c(ext_i2c)
    {
        sensor_centre = new VL53L3CX(ext_i2c, 0, A2);
        sensor_left = new VL53L3CX(dev_i2c, 0, D8);
        sensor_right = new VL53L3CX(dev_i2c, 0, D2);
    }  
    
    /** Constructor 2
     * @param[in] &i2c device I2C to be used for communication
     * @param[in] PinName gpio1_top Mbed DigitalOut pin name to be used as a top sensor GPIO_1 INT
     * @param[in] PinName gpio1_bottom Mbed DigitalOut pin name to be used as a bottom sensor GPIO_1 INT
     * @param[in] PinName gpio1_left Mbed DigitalOut pin name to be used as a left sensor GPIO_1 INT
     * @param[in] PinName gpio1_right Mbed DigitalOut pin name to be used as a right sensor GPIO_1 INT
     */
    NoShield53L3(vl53L3_DevI2C *ext_i2c, PinName gpio1_centre,
                  PinName gpio1_left, PinName gpio1_right) : dev_i2c(ext_i2c)
    {
        printf("NoShield53L3 constructor %d %d %d %d\n",(int)ext_i2c,gpio1_centre,gpio1_left,gpio1_right);

        sensor_centre = new VL53L3CX(dev_i2c, 0, gpio1_centre);
        sensor_left = new VL53L3CX(dev_i2c, 0, gpio1_left);
        sensor_right = new VL53L3CX(dev_i2c, 0, gpio1_right);
    }    
    
    
    /** Destructor
     */
    ~NoShield53L3()
    {

        if (sensor_centre != NULL) {
            delete sensor_centre;
            sensor_centre = NULL;
        }

        if (sensor_left != NULL) {
            delete sensor_left;
            sensor_left = NULL;
        }

        if (sensor_right != NULL) {
            delete sensor_right;
            sensor_right = NULL;
        }    

        _instance = NULL;
    }


    /**
     * @brief       Creates a singleton object instance
     * @param[in]   &i2c device I2C to be used for communication
     * @return      Pointer to the object instance
     */
    static NoShield53L3 *instance(vl53L3_DevI2C *ext_i2c);

    /**
     * @brief       Creates a singleton object instance
     * @param[in]   &i2c device I2C to be used for communication
     * @param[in]   PinName gpio1_centre the pin connected to top sensor INT
     * @param[in]   PinName gpio1_left the pin connected to left sensor INT
     * @param[in]   PinName gpio1_right the pin connected to right sensor INT
     * @return      Pointer to the object instance
     */
    static NoShield53L3 *instance(vl53L3_DevI2C *ext_i2c, PinName gpio1_centre,
                                   PinName gpio1_left, PinName gpio1_right);

    /**
     * @brief       Initialize the board and sensors with deft values
     * @return      0 on success
     */
    int init_board();
    int init_board(PinName shut_centre, PinName shut_left, PinName shut_right);
    
    vl53L3_DevI2C *dev_i2c;
    VL53L3CX *sensor_centre;
    VL53L3CX *sensor_left;
    VL53L3CX *sensor_right;
    
private:
    static NoShield53L3 *_instance;
};


#endif /* __VL53L1_NO_SHIELD_CLASS_H */