
/*
* This file is part of VL53L3 Platform
*
* This file provides a CPP wrapper around the functions in 53l3a2_ranging_sensor.c
* For documentation look at 53l3a2_ranging_sensor.h
*
* Copyright (C) 2021, STMicroelectronics - All Rights Reserved
*
* License terms: BSD 3-clause "New" or "Revised" License.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice, this
* list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright notice,
* this list of conditions and the following disclaimer in the documentation
* and/or other materials provided with the distribution.
*
* 3. Neither the name of the copyright holder nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#include "VL53L3A2_RangingClass.h"



int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_Init(uint32_t Instance)
{
    return VL53L3A2_RANGING_SENSOR_Init(Instance);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_DeInit(uint32_t Instance)
{
    return VL53L3A2_RANGING_SENSOR_DeInit(Instance);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_ReadID(uint32_t Instance, uint32_t *pId)
{
    return VL53L3A2_RANGING_SENSOR_ReadID(Instance,pId);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_GetCapabilities(uint32_t Instance, RANGING_SENSOR_Capabilities_t *pCapabilities)
{
    return VL53L3A2_RANGING_SENSOR_GetCapabilities(Instance, pCapabilities);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_ConfigProfile(uint32_t Instance, RANGING_SENSOR_ProfileConfig_t *pConfig)
{
    return VL53L3A2_RANGING_SENSOR_ConfigProfile( Instance, pConfig);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_ConfigROI(uint32_t Instance, RANGING_SENSOR_ROIConfig_t *pConfig)
{
    return VL53L3A2_RANGING_SENSOR_ConfigROI(Instance, pConfig);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_ConfigIT(uint32_t Instance, RANGING_SENSOR_ITConfig_t *pConfig)
{
    return VL53L3A2_RANGING_SENSOR_ConfigIT(Instance, pConfig);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_GetDistance(uint32_t Instance, RANGING_SENSOR_Result_t *pResult)
{
    return VL53L3A2_RANGING_SENSOR_GetDistance( Instance, pResult);
}


int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_Start(uint32_t Instance, uint32_t Mode)
{
    return VL53L3A2_RANGING_SENSOR_Start( Instance, Mode);
}


int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_Stop(uint32_t Instance)
{
    return VL53L3A2_RANGING_SENSOR_Stop( Instance);
}


int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_SetAddress(uint32_t Instance, uint32_t Address)
{
    return VL53L3A2_RANGING_SENSOR_SetAddress( Instance, Address);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_GetAddress(uint32_t Instance, uint32_t *pAddress)
{
    return VL53L3A2_RANGING_SENSOR_GetAddress( Instance, pAddress);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_SetPowerMode(uint32_t Instance, uint32_t PowerMode)
{
    return VL53L3A2_RANGING_SENSOR_SetPowerMode( Instance, PowerMode);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_GetPowerMode(uint32_t Instance, uint32_t *pPowerMode)
{
    return VL53L3A2_RANGING_SENSOR_GetPowerMode( Instance, pPowerMode);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_OffsetCalibration(uint32_t Instance, uint32_t CalDistance)
{
    return VL53L3A2_RANGING_SENSOR_OffsetCalibration( Instance, CalDistance);
}

int32_t VL53L3A2_SENSOR::VL53L3A2_RANGING_XTalkCalibration(uint32_t Instance)
{
    return VL53L3A2_RANGING_SENSOR_XTalkCalibration( Instance);
}
