/**
 ******************************************************************************
 * @file    vl53l3x_class.cpp
 * @author  CGM
 * @version V0.0.1
 * @date    14-December-2021
 * @brief   Implementation file for the VL53LX driver class
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2021 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
* This is just a CPP wrapper around the C files in the module directory which 
* are from the bare-driver release.
*/
 

/* Includes */
#include <stdlib.h>

#include "mbed.h"

#include "pinmap.h"
//#include "Arduino.h"
#include "vl53l3cx_class.h"
#include "vl53L3_I2c.h"
#include "vl53lx_platform.h"

#include "vl53lx_ll_def.h"


#include "vl53lx_core_support.h"
#include "vl53lx_def.h"
#include "vl53lx_api_calibration.h"
#include "vl53lx_core.h"
#include "vl53lx_api.h"
#include "vl53lx_wait.h"
#include "vl53lx_register_settings.h"
#include "vl53lx_register_funcs.h"
#include "vl53lx_platform_ipp.h"
#include "vl53lx_nvm.h"
#include "vl53lx_api_core.h"
#include "vl53lx_hist_map.h"
#include "vl53lx_api_preset_modes.h"
#include "vl53lx_xtalk.h"
#include "vl53lx_hist_core.h"
#include "vl53lx_hist_algos_gen3.h"
#include "vl53lx_hist_algos_gen4.h"
#include "vl53lx_dmax.h"
#include "vl53lx_sigma_estimate.h"
#include "vl53lx_hist_core.h"
#include "vl53lx_hist_funcs.h"
#include "vl53lx_silicon_core.h"



#define TEMP_BUF_SIZE 80

VL53LX_Error VL53L3CX::VL53L3CX_I2CWrite(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t *pBuffer, uint16_t NumByteToWrite)
{
    
   return  i2c_inst->VL53L3_i2c_write(pBuffer,DeviceAddr,RegisterAddr,NumByteToWrite);
}


VL53LX_Error VL53L3CX::VL53L3CX_I2CRead(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t *pBuffer, uint16_t NumByteToRead)
{
  
    return   i2c_inst->VL53L3_i2c_read(pBuffer,DeviceAddr,RegisterAddr,NumByteToRead);
}


VL53LX_Error VL53L3CX::VL53L3CX_GetTickCount(
  uint32_t *ptick_count_ms)
{
	
	return VL53LX_GetTickCount(Dev,ptick_count_ms);

  /* Returns current tick count in [ms] */

}



VL53LX_Error VL53L3CX::VL53L3CX_WaitUs(VL53LX_Dev_t *pdev, int32_t wait_num_us)
{
//  (void)pdev;
  //delay(wait_us / 1000);
  wait_ms(wait_num_us/1000);
  return VL53LX_ERROR_NONE;
}


VL53LX_Error VL53L3CX::VL53L3CX_WaitMs(VL53LX_DEV Dev, int32_t wait_num_ms)
{
    return VL53LX_WaitMs(Dev,wait_num_ms);
}


VL53LX_Error VL53L3CX::VL53L3CX_WaitValueMaskEx(
  VL53LX_DEV Dev,
  uint32_t      timeout_ms,
  uint16_t      index,
  uint8_t       value,
  uint8_t       mask,
  uint32_t      poll_delay_ms)
{

	return VL53LX_WaitValueMaskEx(
		Dev,
		timeout_ms,
		index,
		value,
		mask,
		poll_delay_ms);

}



/* vl53lx_api_core.c */



VL53LX_Error VL53L3CX::VL53L3CX_load_patch()
{
	
	return VL53LX_load_patch(Dev);
}	

  

VL53LX_Error VL53L3CX::VL53L3CX_unload_patch()
{
  return VL53LX_unload_patch(Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_get_version(VL53LX_ll_version_t *pdata)
{
	return VL53LX_get_version(Dev, pdata);
}





VL53LX_Error VL53L3CX::VL53L3CX_data_init(uint8_t  read_p2p_data)
{
	return  VL53LX_data_init(Dev,read_p2p_data);
}

VL53LX_Error VL53L3CX::VL53L3CX_read_p2p_data()
{
	return VL53LX_read_p2p_data(Dev);
}




VL53LX_Error VL53L3CX::VL53L3CX_set_part_to_part_data(VL53LX_calibration_data_t            *pcal_data)
{
	return VL53LX_set_part_to_part_data(Dev, pcal_data);
}

VL53LX_Error VL53L3CX::VL53L3CX_get_part_to_part_data(VL53LX_calibration_data_t      *pcal_data)
{
	return VL53LX_get_part_to_part_data(Dev, pcal_data);
}

VL53LX_Error VL53L3CX::VL53L3CX_set_inter_measurement_period_ms(
  uint32_t                inter_measurement_period_ms)
{
	return VL53LX_set_inter_measurement_period_ms(Dev,inter_measurement_period_ms);
}

VL53LX_Error VL53L3CX::VL53L3CX_get_inter_measurement_period_ms(uint32_t               *pinter_measurement_period_ms)
{
	return VL53LX_get_inter_measurement_period_ms(Dev, pinter_measurement_period_ms);
}

VL53LX_Error VL53L3CX::VL53L3CX_set_timeouts_us(
  uint32_t            phasecal_config_timeout_us,
  uint32_t            mm_config_timeout_us,
  uint32_t            range_config_timeout_us)
{
	
	return 	VL53LX_set_timeouts_us(Dev,
	                               phasecal_config_timeout_us,
			                       mm_config_timeout_us, 
								   range_config_timeout_us);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_timeouts_us(
  uint32_t            *pphasecal_config_timeout_us,
  uint32_t            *pmm_config_timeout_us,
  uint32_t      *prange_config_timeout_us)
{
	
	return  VL53LX_get_timeouts_us(Dev, 
			                       pphasecal_config_timeout_us,
			                       pmm_config_timeout_us, 
								   prange_config_timeout_us);
			
}




VL53LX_Error VL53L3CX::VL53L3CX_set_user_zone(
  VL53LX_user_zone_t     *puser_zone)
{
	return VL53LX_set_user_zone(
		Dev,
		puser_zone);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_user_zone(
  VL53LX_user_zone_t     *puser_zone)
{
    return  VL53LX_get_user_zone( Dev, puser_zone);
}

VL53LX_Error VL53L3CX::VL53L3CX_get_mode_mitigation_roi(
  VL53LX_user_zone_t     *pmm_roi)
{

	return	VL53LX_get_mode_mitigation_roi( Dev, pmm_roi);
}

VL53LX_Error VL53L3CX::VL53L3CX_set_zone_config(
  VL53LX_zone_config_t      *pzone_cfg)
{
	
	return VL53LX_set_zone_config(Dev, pzone_cfg );
			
}



VL53LX_Error VL53L3CX::VL53L3CX_get_zone_config(
  VL53LX_zone_config_t      *pzone_cfg)
{
	
	return VL53LX_get_zone_config(Dev, pzone_cfg);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_preset_mode_timing_cfg(
  VL53LX_DevicePresetModes     device_preset_mode,
  uint16_t                    *pdss_config__target_total_rate_mcps,
  uint32_t                    *pphasecal_config_timeout_us,
  uint32_t                    *pmm_config_timeout_us,
  uint32_t                    *prange_config_timeout_us)
{
	
	return VL53LX_get_preset_mode_timing_cfg(Dev,
				device_preset_mode,
				pdss_config__target_total_rate_mcps,
				pphasecal_config_timeout_us,
				pmm_config_timeout_us,
				prange_config_timeout_us);
				
}

VL53LX_Error VL53L3CX::VL53L3CX_set_preset_mode(
  VL53LX_DevicePresetModes     device_preset_mode,
  uint16_t                     dss_config__target_total_rate_mcps,
  uint32_t                     phasecal_config_timeout_us,
  uint32_t                     mm_config_timeout_us,
  uint32_t                     range_config_timeout_us,
  uint32_t                     inter_measurement_period_ms)
{
	
	return VL53LX_set_preset_mode(
				Dev,
				device_preset_mode,
				dss_config__target_total_rate_mcps,
				phasecal_config_timeout_us,
				mm_config_timeout_us,
				range_config_timeout_us,
				inter_measurement_period_ms);

}


VL53LX_Error  VL53L3CX::VL53L3CX_enable_xtalk_compensation()
{
	
	return VL53LX_enable_xtalk_compensation(Dev);
	   
}

void VL53L3CX::VL53L3CX_get_xtalk_compensation_enable(uint8_t       *pcrosstalk_compensation_enable)
{
	return 	VL53LX_get_xtalk_compensation_enable(Dev,pcrosstalk_compensation_enable);
		
}






VL53LX_Error  VL53L3CX::VL53L3CX_disable_xtalk_compensation()
{
	
	return VL53LX_disable_xtalk_compensation(Dev);

}




VL53LX_Error VL53L3CX::VL53L3CX_init_and_start_range(
  uint8_t                        measurement_mode,
  VL53LX_DeviceConfigLevel       device_config_level)
{
	
	return  VL53LX_init_and_start_range( Dev, measurement_mode, device_config_level);

}
VL53LX_Error VL53L3CX::VL53L3CX_stop_range()
{
    return VL53LX_stop_range(Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_get_measurement_results(
  VL53LX_DeviceResultsLevel      device_results_level)
{
	
	return VL53LX_get_measurement_results( Dev, device_results_level);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_get_device_results(
  VL53LX_DeviceResultsLevel     device_results_level,
  VL53LX_range_results_t       *prange_results)
{
    return  VL53LX_get_device_results(  Dev,  device_results_level,prange_results);
}

VL53LX_Error VL53L3CX::VL53L3CX_clear_interrupt_and_enable_next_range(
  uint8_t           measurement_mode)
{
	return VL53LX_clear_interrupt_and_enable_next_range(Dev,measurement_mode);	
}


VL53LX_Error VL53L3CX::VL53L3CX_get_histogram_bin_data(
  VL53LX_histogram_bin_data_t *pdata)
{
	return VL53LX_get_histogram_bin_data(Dev, pdata);
}

void VL53L3CX::VL53L3CX_copy_sys_and_core_results_to_range_results(
  int32_t                           gain_factor,
  VL53LX_system_results_t          *psys,
  VL53LX_core_results_t            *pcore,
  VL53LX_range_results_t           *presults)
{
	
	return VL53LX_copy_sys_and_core_results_to_range_results(
			gain_factor,
			psys,
			pcore,
			presults);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_zone_dss_config(
  VL53LX_zone_private_dyn_cfg_t  *pzone_dyn_cfg)
{
	
    return VL53LX_set_zone_dss_config(  Dev,
										pzone_dyn_cfg);

}



VL53LX_Error VL53L3CX::VL53L3CX_set_dmax_mode(
  VL53LX_DeviceDmaxMode    dmax_mode)
{
	
	return VL53LX_set_dmax_mode(Dev,dmax_mode);
			
}


VL53LX_Error VL53L3CX::VL53L3CX_get_dmax_mode(
  VL53LX_DeviceDmaxMode   *pdmax_mode)
{
	
	return VL53LX_get_dmax_mode( Dev,pdmax_mode);
	
}


VL53LX_Error VL53L3CX::VL53L3CX_get_dmax_calibration_data(
  VL53LX_DeviceDmaxMode           dmax_mode,
  VL53LX_dmax_calibration_data_t *pdmax_cal)
{

    return   VL53LX_get_dmax_calibration_data(Dev, dmax_mode, pdmax_cal);

}




VL53LX_Error VL53L3CX::VL53L3CX_set_offset_correction_mode(
  VL53LX_OffsetCorrectionMode    offset_cor_mode)
{
	
	return   VL53LX_set_offset_correction_mode(Dev,	offset_cor_mode);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_offset_correction_mode(
  VL53LX_OffsetCorrectionMode   *poffset_cor_mode)
{
    return  VL53LX_get_offset_correction_mode( Dev, poffset_cor_mode);

}



VL53LX_Error VL53L3CX::VL53L3CX_get_tuning_debug_data(
  VL53LX_tuning_parameters_t           *ptun_data)
{
	
	return VL53LX_get_tuning_debug_data(Dev,ptun_data);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_tuning_parm(
  VL53LX_TuningParms             tuning_parm_key,
  int32_t                       *ptuning_parm_value)
{

    return 	VL53LX_get_tuning_parm(Dev, tuning_parm_key,
			                       ptuning_parm_value);

}


VL53LX_Error VL53L3CX::VL53L3CX_set_tuning_parm(
  VL53LX_TuningParms    tuning_parm_key,
  int32_t               tuning_parm_value)
{

    return 	VL53LX_set_tuning_parm(Dev, tuning_parm_key, tuning_parm_value);

 }

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_enable()
{

    return  VL53LX_dynamic_xtalk_correction_enable(Dev);

}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_disable()
{
	return  VL53LX_dynamic_xtalk_correction_disable(Dev);

}
VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_apply_enable()
{
	
	return VL53LX_dynamic_xtalk_correction_apply_enable(Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_apply_disable()
{
	
	return VL53LX_dynamic_xtalk_correction_apply_disable(Dev);

}


VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_single_apply_enable()
{
	
  return VL53LX_dynamic_xtalk_correction_single_apply_enable(Dev);

}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_single_apply_disable()
{

    return VL53LX_dynamic_xtalk_correction_single_apply_disable(Dev);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_current_xtalk_settings(
  VL53LX_xtalk_calibration_results_t *pxtalk
)
{

    return  VL53LX_get_current_xtalk_settings(Dev,pxtalk);

}
VL53LX_Error VL53L3CX::VL53L3CX_set_current_xtalk_settings(
  VL53LX_xtalk_calibration_results_t *pxtalk
)
{
    return VL53LX_set_current_xtalk_settings(Dev, pxtalk);

}

/* vl53lx_register_funcs.c */

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_static_nvm_managed(
  VL53LX_static_nvm_managed_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return   VL53LX_i2c_encode_static_nvm_managed( pdata, buf_size, pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_static_nvm_managed(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_static_nvm_managed_t  *pdata)
{
	
	
	return 	VL53LX_i2c_decode_static_nvm_managed(
			buf_size,
			pbuffer,
			pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_static_nvm_managed(
  VL53LX_static_nvm_managed_t  *pdata)
{
	
	return VL53LX_set_static_nvm_managed( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_static_nvm_managed(
  VL53LX_static_nvm_managed_t  *pdata)
{
	
	return VL53LX_get_static_nvm_managed( Dev,
										  pdata);	
	
}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_customer_nvm_managed(
  VL53LX_customer_nvm_managed_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{


    return 	VL53LX_i2c_encode_customer_nvm_managed( pdata,
													buf_size,
													pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_customer_nvm_managed(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_customer_nvm_managed_t  *pdata)
{
	
	return VL53LX_i2c_decode_customer_nvm_managed( buf_size,
												   pbuffer,
												   pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_customer_nvm_managed(
  VL53LX_customer_nvm_managed_t  *pdata)
{
	
	
	return 	VL53LX_set_customer_nvm_managed(Dev,
											pdata);
				
}

VL53LX_Error VL53L3CX::VL53L3CX_get_customer_nvm_managed(
  VL53LX_customer_nvm_managed_t  *pdata)
{

    return 	VL53LX_get_customer_nvm_managed(Dev,pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_static_config(
  VL53LX_static_config_t   *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return 	VL53LX_i2c_encode_static_config(pdata, buf_size, pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_static_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_static_config_t    *pdata)
{

	return VL53LX_i2c_decode_static_config( buf_size, pbuffer, pdata);

 }

VL53LX_Error VL53L3CX::VL53L3CX_set_static_config(
  VL53LX_static_config_t    *pdata)
{

    return  VL53LX_set_static_config(Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_static_config(
  VL53LX_static_config_t    *pdata)
{

    return  VL53LX_get_static_config( Dev, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_general_config(
  VL53LX_general_config_t  *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return  VL53LX_i2c_encode_general_config(
			pdata,
			buf_size,
			pbuffer);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_general_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_general_config_t   *pdata)
{

    return  VL53LX_i2c_decode_general_config(
			buf_size,
			pbuffer,
			pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_general_config(
  VL53LX_general_config_t   *pdata)
{
	
	return VL53LX_set_general_config( Dev, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_general_config(
  VL53LX_general_config_t   *pdata)
{

    return VL53LX_get_general_config( Dev,pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_timing_config(
  VL53LX_timing_config_t   *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return  VL53LX_i2c_encode_timing_config(
			pdata,
			buf_size,
			pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_timing_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_timing_config_t    *pdata)
{
	
	return	VL53LX_i2c_decode_timing_config(
			buf_size,
			pbuffer,
			pdata);

 }

VL53LX_Error VL53L3CX::VL53L3CX_set_timing_config(
  VL53LX_timing_config_t    *pdata)
{
		
	return VL53LX_set_timing_config( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_timing_config(
  VL53LX_timing_config_t    *pdata)
{
	
	return  VL53LX_set_timing_config( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_dynamic_config(
  VL53LX_dynamic_config_t  *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return VL53LX_i2c_encode_dynamic_config( pdata, buf_size, pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_dynamic_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_dynamic_config_t   *pdata)
{

	return VL53LX_i2c_decode_dynamic_config(buf_size,pbuffer,pdata);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_set_dynamic_config(
  VL53LX_dynamic_config_t   *pdata)
{

    return  VL53LX_set_dynamic_config(  Dev, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_dynamic_config(
  VL53LX_dynamic_config_t   *pdata)
{
	
	return VL53LX_get_dynamic_config(  Dev,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_system_control(
  VL53LX_system_control_t  *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return 	VL53LX_i2c_encode_system_control(   pdata,
												buf_size,
												pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_system_control(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_system_control_t   *pdata)
{
	
	
	return VL53LX_i2c_decode_system_control(
								buf_size,
								pbuffer,
								pdata);



}


VL53LX_Error VL53L3CX::VL53L3CX_set_system_control(
  VL53LX_system_control_t   *pdata)
{
	
	return 	VL53LX_set_system_control(Dev,pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_system_control(
  VL53LX_system_control_t   *pdata)
{

	return 	VL53LX_get_system_control(Dev,pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_system_results(
  VL53LX_system_results_t  *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return VL53LX_i2c_encode_system_results(pdata,
			buf_size,
			pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_system_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_system_results_t   *pdata)
{
	
	
	return  VL53LX_i2c_decode_system_results( buf_size,pbuffer,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_system_results(
  VL53LX_system_results_t   *pdata)
{
	
	return  VL53LX_set_system_results(Dev,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_system_results(
  VL53LX_system_results_t   *pdata)
{

	return  VL53LX_get_system_results(Dev,pdata);
	
}
VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_core_results(
  VL53LX_core_results_t    *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	
	return 	VL53LX_i2c_encode_core_results(
										pdata,
										buf_size,
										pbuffer);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_core_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_core_results_t     *pdata)
{
	
	
	return VL53LX_i2c_decode_core_results( buf_size,
										   pbuffer,
										   pdata);
}

VL53LX_Error VL53L3CX::VL53L3CX_set_core_results(
  VL53LX_core_results_t     *pdata)
{
	
	return VL53LX_set_core_results( Dev, pdata);
	
}


VL53LX_Error VL53L3CX::VL53L3CX_get_core_results(
  VL53LX_core_results_t     *pdata)
{

	return VL53LX_get_core_results( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_debug_results(
  VL53LX_debug_results_t   *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return 	VL53LX_i2c_encode_debug_results(pdata, buf_size, pbuffer);


}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_debug_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_debug_results_t    *pdata)
{
	
	return  VL53LX_i2c_decode_debug_results(buf_size,pbuffer,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_debug_results(
  VL53LX_debug_results_t    *pdata)
{
	
	return  VL53LX_set_debug_results(Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_debug_results(
  VL53LX_debug_results_t    *pdata)
{
	
	return  VL53LX_get_debug_results( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_nvm_copy_data(
  VL53LX_nvm_copy_data_t   *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return VL53LX_i2c_encode_nvm_copy_data(pdata,buf_size,pbuffer);

}



VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_nvm_copy_data(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_nvm_copy_data_t    *pdata)
{

	return VL53LX_i2c_decode_nvm_copy_data(
			buf_size,
			pbuffer,
			pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_set_nvm_copy_data(
  VL53LX_nvm_copy_data_t    *pdata)
{
	
	return VL53LX_set_nvm_copy_data( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_nvm_copy_data(
  VL53LX_nvm_copy_data_t    *pdata)
{
	
	return VL53LX_get_nvm_copy_data(Dev, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_prev_shadow_system_results(
  VL53LX_prev_shadow_system_results_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{

	return VL53LX_i2c_encode_prev_shadow_system_results(
			pdata,
			buf_size,
			pbuffer);
			
}



VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_prev_shadow_system_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_prev_shadow_system_results_t  *pdata)
{
	
	return VL53LX_i2c_decode_prev_shadow_system_results( buf_size, pbuffer, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_prev_shadow_system_results(
  VL53LX_prev_shadow_system_results_t  *pdata)
{

    return VL53LX_set_prev_shadow_system_results( Dev,pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_get_prev_shadow_system_results(
  VL53LX_prev_shadow_system_results_t  *pdata)
{
	
	return  VL53LX_get_prev_shadow_system_results( Dev,pdata);

}
VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_prev_shadow_core_results(
  VL53LX_prev_shadow_core_results_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{

	return VL53LX_i2c_encode_prev_shadow_core_results( pdata, buf_size, pbuffer);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_prev_shadow_core_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_prev_shadow_core_results_t  *pdata)
{

	return VL53LX_i2c_decode_prev_shadow_core_results( buf_size, pbuffer, pdata);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_set_prev_shadow_core_results(
  VL53LX_prev_shadow_core_results_t  *pdata)
{
	
	return VL53LX_set_prev_shadow_core_results(Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_prev_shadow_core_results(
  VL53LX_prev_shadow_core_results_t  *pdata)
{
	
	return VL53LX_get_prev_shadow_core_results( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_patch_debug(
  VL53LX_patch_debug_t     *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return  VL53LX_i2c_encode_patch_debug(
			pdata,
			buf_size,
			pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_patch_debug(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_patch_debug_t      *pdata)
{

	return VL53LX_i2c_decode_patch_debug(
			buf_size,
			pbuffer,
			pdata);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_set_patch_debug(
  VL53LX_patch_debug_t      *pdata)
{
	
	return  VL53LX_set_patch_debug(  Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_patch_debug(
  VL53LX_patch_debug_t      *pdata)
{
	
	return VL53LX_get_patch_debug( Dev,pdata);

}
VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_gph_general_config(
  VL53LX_gph_general_config_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
		
	return VL53LX_i2c_encode_gph_general_config( pdata, buf_size, pbuffer);

}
VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_gph_general_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_gph_general_config_t  *pdata)
{
	
	return VL53LX_i2c_decode_gph_general_config( buf_size, pbuffer, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_gph_general_config(
  VL53LX_gph_general_config_t  *pdata)
{
	
	return VL53LX_set_gph_general_config( Dev, pdata);

}
VL53LX_Error VL53L3CX::VL53L3CX_get_gph_general_config(
  VL53LX_gph_general_config_t  *pdata)
{

	return VL53LX_get_gph_general_config( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_gph_static_config(
  VL53LX_gph_static_config_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	
	return VL53LX_i2c_encode_gph_static_config(
			pdata,
			buf_size,
			pbuffer);


}
VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_gph_static_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_gph_static_config_t  *pdata)
{

	return VL53LX_i2c_decode_gph_static_config(
			buf_size,
			pbuffer,
			pdata);

}
VL53LX_Error VL53L3CX::VL53L3CX_set_gph_static_config(
  VL53LX_gph_static_config_t  *pdata)
{
	
	return VL53LX_set_gph_static_config( Dev, pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_get_gph_static_config(
  VL53LX_gph_static_config_t  *pdata)
{
	
	return VL53LX_get_gph_static_config( Dev,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_gph_timing_config(
  VL53LX_gph_timing_config_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return VL53LX_i2c_encode_gph_timing_config( pdata,
												buf_size,
												pbuffer);


}


VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_gph_timing_config(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_gph_timing_config_t  *pdata)
{
	
	return VL53LX_i2c_decode_gph_timing_config(
			buf_size,
			pbuffer,
			pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_gph_timing_config(
  VL53LX_gph_timing_config_t  *pdata)
{

    return  VL53LX_set_gph_timing_config( Dev,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_gph_timing_config(
  VL53LX_gph_timing_config_t  *pdata)
{

    return  VL53LX_get_gph_timing_config(Dev, pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_fw_internal(
  VL53LX_fw_internal_t     *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{

	return VL53LX_i2c_encode_fw_internal(
			pdata,
			buf_size,
			pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_fw_internal(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_fw_internal_t      *pdata)
{

	return VL53LX_i2c_decode_fw_internal( buf_size, pbuffer, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_fw_internal(
  VL53LX_fw_internal_t      *pdata)
{
	
	return VL53LX_set_fw_internal( Dev,pdata);

}
VL53LX_Error VL53L3CX::VL53L3CX_get_fw_internal(
  VL53LX_fw_internal_t      *pdata)
{

    return VL53LX_get_fw_internal( Dev, pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_patch_results(
  VL53LX_patch_results_t   *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
	return  VL53LX_i2c_encode_patch_results(pdata, buf_size, pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_patch_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_patch_results_t    *pdata)
{
    return VL53LX_i2c_decode_patch_results( buf_size, pbuffer, pdata);
}


VL53LX_Error VL53L3CX::VL53L3CX_set_patch_results(
  VL53LX_patch_results_t    *pdata)
{
	
	return VL53LX_set_patch_results( Dev, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_patch_results(
  VL53LX_patch_results_t    *pdata)
{
	
	return  VL53LX_get_patch_results( Dev, pdata);
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_shadow_system_results(
  VL53LX_shadow_system_results_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	return VL53LX_i2c_encode_shadow_system_results(pdata,buf_size,pbuffer);
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_shadow_system_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_shadow_system_results_t  *pdata)
{
	return VL53LX_i2c_decode_shadow_system_results( buf_size, pbuffer,pdata);
}

VL53LX_Error VL53L3CX::VL53L3CX_set_shadow_system_results(
  VL53LX_shadow_system_results_t  *pdata)
{
	
	return VL53LX_set_shadow_system_results( Dev, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_get_shadow_system_results(
  VL53LX_shadow_system_results_t  *pdata)
{

   return  VL53LX_get_shadow_system_results( Dev, pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_encode_shadow_core_results(
  VL53LX_shadow_core_results_t *pdata,
  uint16_t                  buf_size,
  uint8_t                  *pbuffer)
{
	
    return VL53LX_i2c_encode_shadow_core_results( pdata, buf_size, pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_i2c_decode_shadow_core_results(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_shadow_core_results_t  *pdata)
{
	
	return  VL53LX_i2c_decode_shadow_core_results( buf_size,pbuffer,pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_set_shadow_core_results(
  VL53LX_shadow_core_results_t  *pdata)
{
		
    return  VL53LX_set_shadow_core_results( Dev,pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_get_shadow_core_results(
  VL53LX_shadow_core_results_t  *pdata)
{
	
    return VL53LX_get_shadow_core_results( Dev,pdata);
	
}


/* vl53lx_nvm.c */

VL53LX_Error VL53L3CX::VL53L3CX_nvm_enable(
  uint16_t        nvm_ctrl_pulse_width,
  int32_t         nvm_power_up_delay_us)
{
	
	return VL53LX_nvm_enable(Dev, nvm_ctrl_pulse_width, nvm_power_up_delay_us);

}

VL53LX_Error VL53L3CX::VL53L3CX_nvm_read(
  uint8_t       start_address,
  uint8_t       count,
  uint8_t      *pdata)
{
	
	return  VL53LX_nvm_read( Dev, start_address, count, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_nvm_disable()
{
	
	return VL53LX_nvm_disable( Dev );

}


VL53LX_Error VL53L3CX::VL53L3CX_nvm_format_decode(
  uint16_t                   buf_size,
  uint8_t                   *pbuffer,
  VL53LX_decoded_nvm_data_t *pdata)
{
	
	return VL53LX_nvm_disable( Dev );

}
VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_optical_centre(
  uint16_t                    buf_size,
  uint8_t                    *pbuffer,
  VL53LX_optical_centre_t    *pdata)
{
	
	return VL53LX_nvm_decode_optical_centre( buf_size, pbuffer, pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_cal_peak_rate_map(
  uint16_t                    buf_size,
  uint8_t                    *pbuffer,
  VL53LX_cal_peak_rate_map_t *pdata)
{

	return  VL53LX_nvm_decode_cal_peak_rate_map( buf_size, pbuffer, pdata);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_additional_offset_cal_data(
  uint16_t                             buf_size,
  uint8_t                             *pbuffer,
  VL53LX_additional_offset_cal_data_t *pdata)
{
	
	return VL53LX_nvm_decode_additional_offset_cal_data( buf_size, pbuffer, pdata);
	
}


VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_fmt_range_results_data(
  uint16_t                             buf_size,
  uint8_t                             *pbuffer,
  VL53LX_decoded_nvm_fmt_range_data_t *pdata)
{
	
	return VL53LX_nvm_decode_fmt_range_results_data( buf_size, pbuffer,pdata);
	
}


VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_fmt_info(
  uint16_t                       buf_size,
  uint8_t                       *pbuffer,
  VL53LX_decoded_nvm_fmt_info_t *pdata)
{
	
	return VL53LX_nvm_decode_fmt_info( buf_size, pbuffer, pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_nvm_decode_ews_info(
  uint16_t                       buf_size,
  uint8_t                       *pbuffer,
  VL53LX_decoded_nvm_ews_info_t *pdata)
{
	
	
	return VL53LX_nvm_decode_ews_info(
				buf_size,
				pbuffer,
				pdata);


}


void VL53L3CX::VL53L3CX_nvm_format_encode(
  VL53LX_decoded_nvm_data_t *pnvm_info,
  uint8_t                   *pnvm_data)
{
  SUPPRESS_UNUSED_WARNING(pnvm_info);
  SUPPRESS_UNUSED_WARNING(pnvm_data);
}

VL53LX_Error VL53L3CX::VL53L3CX_read_nvm_raw_data(
  uint8_t        start_address,
  uint8_t        count,
  uint8_t       *pnvm_raw_data)
{

	return 	VL53LX_read_nvm_raw_data(
			Dev,
			start_address,
			count,
			pnvm_raw_data);

}

VL53LX_Error VL53L3CX::VL53L3CX_read_nvm(
  uint8_t                    nvm_format,
  VL53LX_decoded_nvm_data_t *pnvm_info)
{

    return VL53LX_read_nvm(Dev, nvm_format,pnvm_info);

}

VL53LX_Error VL53L3CX::VL53L3CX_read_nvm_optical_centre(
  VL53LX_optical_centre_t          *pcentre)
{
	
	return	VL53LX_read_nvm_optical_centre(
				Dev,
				pcentre);

}

VL53LX_Error VL53L3CX::VL53L3CX_read_nvm_cal_peak_rate_map(
  VL53LX_cal_peak_rate_map_t          *pcal_data)
{


    return 	VL53LX_read_nvm_cal_peak_rate_map(
				Dev,
				pcal_data);

}


VL53LX_Error VL53L3CX::VL53L3CX_read_nvm_additional_offset_cal_data(
  VL53LX_additional_offset_cal_data_t *pcal_data)
{

	return VL53LX_read_nvm_additional_offset_cal_data(
				Dev,
				pcal_data);

}

VL53LX_Error VL53L3CX::VL53L3CX_read_nvm_fmt_range_results_data(
  uint16_t                             range_results_select,
  VL53LX_decoded_nvm_fmt_range_data_t *prange_data)
{
    return 	VL53LX_read_nvm_fmt_range_results_data(
				Dev,
				range_results_select,
				prange_data);

}

/* vl53lx_platform_ipp.c */

VL53LX_Error VL53L3CX::VL53L3CX_ipp_hist_process_data(
  VL53LX_dmax_calibration_data_t    *pdmax_cal,
  VL53LX_hist_gen3_dmax_config_t    *pdmax_cfg,
  VL53LX_hist_post_process_config_t *ppost_cfg,
  VL53LX_histogram_bin_data_t       *pbins,
  VL53LX_xtalk_histogram_data_t     *pxtalk,
  uint8_t                           *pArea1,
  uint8_t                           *pArea2,
  uint8_t                           *phisto_merge_nb,
  VL53LX_range_results_t            *presults)
{
  
   return  VL53L3CX_ipp_hist_process_data( pdmax_cal, pdmax_cfg,ppost_cfg,pbins,pxtalk,pArea1,pArea2,phisto_merge_nb,presults);

}


VL53LX_Error VL53L3CX::VL53L3CX_ipp_hist_ambient_dmax(
  uint16_t                           target_reflectance,
  VL53LX_dmax_calibration_data_t    *pdmax_cal,
  VL53LX_hist_gen3_dmax_config_t    *pdmax_cfg,
  VL53LX_histogram_bin_data_t       *pbins,
  int16_t                           *pambient_dmax_mm)
{


    return VL53LX_ipp_hist_ambient_dmax( Dev,
										 target_reflectance,
										  pdmax_cal,
										  pdmax_cfg,
										  pbins,
										  pambient_dmax_mm);


}


VL53LX_Error VL53L3CX::VL53L3CX_ipp_xtalk_calibration_process_data(
  VL53LX_xtalk_range_results_t       *pxtalk_ranges,
  VL53LX_xtalk_histogram_data_t      *pxtalk_shape,
  VL53LX_xtalk_calibration_results_t *pxtalk_cal)
{

    return VL53LX_ipp_xtalk_calibration_process_data( Dev,
													  pxtalk_ranges,
													  pxtalk_shape,
													  pxtalk_cal);

}




/* vl53lx_hist_funcs.c */

VL53LX_Error VL53L3CX::VL53L3CX_hist_process_data(
  VL53LX_dmax_calibration_data_t     *pdmax_cal,
  VL53LX_hist_gen3_dmax_config_t     *pdmax_cfg,
  VL53LX_hist_post_process_config_t  *ppost_cfg,
  VL53LX_histogram_bin_data_t        *pbins_input,
  VL53LX_xtalk_histogram_data_t      *pxtalk_shape,
  uint8_t                            *pArea1,
  uint8_t                            *pArea2,
  VL53LX_range_results_t             *presults,
  uint8_t                            *HistMergeNumber)
{
	
	return VL53LX_hist_process_data(pdmax_cal,pdmax_cfg,ppost_cfg,pbins_input,
	                                pxtalk_shape,pArea1,pArea2,presults,HistMergeNumber);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_hist_ambient_dmax(
  uint16_t                            target_reflectance,
  VL53LX_dmax_calibration_data_t     *pdmax_cal,
  VL53LX_hist_gen3_dmax_config_t     *pdmax_cfg,
  VL53LX_histogram_bin_data_t        *pbins,
  int16_t                            *pambient_dmax_mm)
{
	
	return VL53LX_hist_ambient_dmax(target_reflectance, pdmax_cal, pdmax_cfg, pbins,pambient_dmax_mm);
	
}

/* vl53lx_core_support.c */

uint32_t VL53L3CX::VL53L3CX_calc_pll_period_us(
  uint16_t  fast_osc_frequency)
{
	
	return VL53LX_calc_pll_period_us(fast_osc_frequency);
	
}

uint32_t  VL53L3CX::VL53L3CX_duration_maths(
  uint32_t  pll_period_us,
  uint32_t  vcsel_parm_pclks,
  uint32_t  window_vclks,
  uint32_t  elapsed_mclks)
{
	
    return   VL53LX_duration_maths( pll_period_us,vcsel_parm_pclks,window_vclks,elapsed_mclks);
	
}

uint32_t VL53L3CX::VL53L3CX_events_per_spad_maths(
  int32_t   VL53LX_p_010,
  uint16_t  num_spads,
  uint32_t  duration)
{
	
	return  VL53LX_events_per_spad_maths( VL53LX_p_010,num_spads, duration);
	
}

uint32_t VL53L3CX::VL53L3CX_isqrt(uint32_t num)
{

  return VL53LX_isqrt(num);

}

void  VL53L3CX::VL53L3CX_hist_calc_zero_distance_phase(
  VL53LX_histogram_bin_data_t   *pdata)
{
	
	return VL53LX_hist_calc_zero_distance_phase(pdata);

}

void  VL53L3CX::VL53L3CX_hist_estimate_ambient_from_thresholded_bins(
  int32_t                        ambient_threshold_sigma,
  VL53LX_histogram_bin_data_t   *pdata)
{
	
    return   VL53LX_hist_estimate_ambient_from_thresholded_bins( ambient_threshold_sigma, pdata);

}


void  VL53L3CX::VL53L3CX_hist_remove_ambient_bins(
  VL53LX_histogram_bin_data_t   *pdata)
{
	
	return   VL53LX_hist_remove_ambient_bins(pdata);
	
}


uint32_t VL53L3CX::VL53L3CX_calc_pll_period_mm(
  uint16_t fast_osc_frequency)
{

   return VL53LX_calc_pll_period_mm( fast_osc_frequency);

}


uint16_t VL53L3CX::VL53L3CX_rate_maths(
  int32_t   VL53LX_p_018,
  uint32_t  time_us)
{
	
	return VL53LX_rate_maths( VL53LX_p_018 , time_us);

}

uint16_t VL53L3CX::VL53L3CX_rate_per_spad_maths(
  uint32_t  frac_bits,
  uint32_t  peak_count_rate,
  uint16_t  num_spads,
  uint32_t  max_output_value)
{
	
	return VL53LX_rate_per_spad_maths( frac_bits,
										peak_count_rate,
										num_spads,
										max_output_value);

}

int32_t VL53L3CX::VL53L3CX_range_maths(
  uint16_t  fast_osc_frequency,
  uint16_t  VL53LX_p_014,
  uint16_t  zero_distance_phase,
  uint8_t   fractional_bits,
  int32_t   gain_factor,
  int32_t   range_offset_mm)
{
	
	return  VL53LX_range_maths( fast_osc_frequency,
								VL53LX_p_014,
								zero_distance_phase,
								fractional_bits,
								gain_factor,
								range_offset_mm);
	
}

uint8_t VL53L3CX::VL53L3CX_decode_vcsel_period(uint8_t vcsel_period_reg)
{
	return  VL53LX_decode_vcsel_period( vcsel_period_reg);

}


void VL53L3CX::VL53L3CX_copy_xtalk_bin_data_to_histogram_data_struct(
  VL53LX_xtalk_histogram_shape_t *pxtalk,
  VL53LX_histogram_bin_data_t    *phist)
{
	
	VL53LX_copy_xtalk_bin_data_to_histogram_data_struct( pxtalk, phist);

}

void VL53L3CX::VL53L3CX_init_histogram_bin_data_struct(
  int32_t                      bin_value,
  uint16_t                     VL53LX_p_021,
  VL53LX_histogram_bin_data_t *pdata)
{
	
	VL53LX_init_histogram_bin_data_struct( bin_value,
										  VL53LX_p_021,
										  pdata);
						
}

void VL53L3CX::VL53L3CX_decode_row_col(
  uint8_t  spad_number,
  uint8_t  *prow,
  uint8_t  *pcol)
{
	
	VL53LX_decode_row_col( spad_number,
						   prow,
						   pcol);

}

void  VL53L3CX::VL53L3CX_hist_find_min_max_bin_values(
  VL53LX_histogram_bin_data_t   *pdata)
{
	
	VL53LX_hist_find_min_max_bin_values(pdata);

}

void  VL53L3CX::VL53L3CX_hist_estimate_ambient_from_ambient_bins(
  VL53LX_histogram_bin_data_t   *pdata)
{
	 VL53LX_hist_estimate_ambient_from_ambient_bins(pdata);

}
/* vl53lx_core.c */
void  VL53L3CX::VL53L3CX_init_version()
{
	VL53LX_init_version(Dev);

}

void  VL53L3CX::VL53L3CX_init_ll_driver_state(
  VL53LX_DeviceState device_state)
{
	
    VL53LX_init_ll_driver_state(Dev, device_state);

}


VL53LX_Error  VL53L3CX::VL53L3CX_update_ll_driver_rd_state()
{

    return VL53LX_update_ll_driver_rd_state(Dev);

}

VL53LX_Error VL53L3CX::VL53L3CX_check_ll_driver_rd_state()
{

    return  VL53LX_check_ll_driver_rd_state(Dev);

}


VL53LX_Error  VL53L3CX::VL53L3CX_update_ll_driver_cfg_state()
{

   return VL53LX_update_ll_driver_cfg_state(Dev);

}

void VL53L3CX::VL53L3CX_copy_rtn_good_spads_to_buffer(
  VL53LX_nvm_copy_data_t  *pdata,
  uint8_t                 *pbuffer)
{
	
	VL53LX_copy_rtn_good_spads_to_buffer( pdata,pbuffer);

}

void VL53L3CX::VL53L3CX_init_system_results(
  VL53LX_system_results_t  *pdata)
{

    VL53LX_init_system_results(pdata);

}
void VL53L3CX::VL53L3CX_init_zone_results_structure(
  uint8_t                 active_zones,
  VL53LX_zone_results_t  *pdata)
{

    V53L1_init_zone_results_structure(active_zones, pdata);

}

void VL53L3CX::VL53L3CX_init_zone_dss_configs()
{
	
	V53L1_init_zone_dss_configs(Dev);

}

void VL53L3CX::VL53L3CX_init_histogram_config_structure(
  uint8_t   even_bin0,
  uint8_t   even_bin1,
  uint8_t   even_bin2,
  uint8_t   even_bin3,
  uint8_t   even_bin4,
  uint8_t   even_bin5,
  uint8_t   odd_bin0,
  uint8_t   odd_bin1,
  uint8_t   odd_bin2,
  uint8_t   odd_bin3,
  uint8_t   odd_bin4,
  uint8_t   odd_bin5,
  VL53LX_histogram_config_t  *pdata)
{
	
	
	VL53LX_init_histogram_config_structure(even_bin0,
										   even_bin1,
										   even_bin2,
										   even_bin3,
										   even_bin4,
										   even_bin5,
										   odd_bin0,
										   odd_bin1,
										   odd_bin2,
										   odd_bin3,
										   odd_bin4,
										   odd_bin5,
										   pdata);

}

void VL53L3CX::VL53L3CX_init_histogram_multizone_config_structure(
  uint8_t   even_bin0,
  uint8_t   even_bin1,
  uint8_t   even_bin2,
  uint8_t   even_bin3,
  uint8_t   even_bin4,
  uint8_t   even_bin5,
  uint8_t   odd_bin0,
  uint8_t   odd_bin1,
  uint8_t   odd_bin2,
  uint8_t   odd_bin3,
  uint8_t   odd_bin4,
  uint8_t   odd_bin5,
  VL53LX_histogram_config_t  *pdata)
{
	
    VL53LX_init_histogram_multizone_config_structure( even_bin0,
													   even_bin1,
													   even_bin2,
													   even_bin3,
													   even_bin4,
													   even_bin5,
													   odd_bin0,
													   odd_bin1,
													   odd_bin2,
													   odd_bin3,
													   odd_bin4,
													   odd_bin5,
													   pdata);

}

void VL53L3CX::VL53L3CX_init_xtalk_bin_data_struct(
  uint32_t                        bin_value,
  uint16_t                        VL53LX_p_021,
  VL53LX_xtalk_histogram_shape_t *pdata)
{
	
	VL53LX_init_xtalk_bin_data_struct( bin_value,
									   VL53LX_p_021,
									   pdata);

}

void VL53L3CX::VL53L3CX_i2c_encode_uint16_t(
  uint16_t    ip_value,
  uint16_t    count,
  uint8_t    *pbuffer)
{

    VL53LX_i2c_encode_uint16_t( ip_value,
								count,
								pbuffer);

}

uint16_t VL53L3CX::VL53L3CX_i2c_decode_uint16_t(
  uint16_t    count,
  uint8_t    *pbuffer)
{

    return  VL53LX_i2c_decode_uint16_t( count, pbuffer);

}

void VL53L3CX::VL53L3CX_i2c_encode_int16_t(
  int16_t     ip_value,
  uint16_t    count,
  uint8_t    *pbuffer)
{

    return VL53LX_i2c_encode_uint16_t( ip_value, count, pbuffer);

}

int16_t VL53L3CX::VL53L3CX_i2c_decode_int16_t(
  uint16_t    count,
  uint8_t    *pbuffer)
{
	
	return VL53LX_i2c_decode_int16_t(count,pbuffer);

}

void VL53L3CX::VL53L3CX_i2c_encode_uint32_t(
  uint32_t    ip_value,
  uint16_t    count,
  uint8_t    *pbuffer)
{
	
	VL53LX_i2c_encode_uint32_t(ip_value,count,pbuffer);

}


uint32_t VL53L3CX::VL53L3CX_i2c_decode_uint32_t(
  uint16_t    count,
  uint8_t    *pbuffer)
{

    return VL53LX_i2c_decode_uint32_t( count, pbuffer);

}

uint32_t VL53L3CX::VL53L3CX_i2c_decode_with_mask(
  uint16_t    count,
  uint8_t    *pbuffer,
  uint32_t    bit_mask,
  uint32_t    down_shift,
  uint32_t    offset)
{

    return  VL53LX_i2c_decode_with_mask( count, pbuffer, bit_mask,down_shift,offset);

}

void VL53L3CX::VL53L3CX_i2c_encode_int32_t(
  int32_t     ip_value,
  uint16_t    count,
  uint8_t    *pbuffer)
{

    return VL53LX_i2c_encode_int32_t( ip_value, count, pbuffer);
	
}

int32_t VL53L3CX::VL53L3CX_i2c_decode_int32_t(
  uint16_t    count,
  uint8_t    *pbuffer)
{

    return VL53LX_i2c_decode_int32_t( count,pbuffer);

}

VL53LX_Error VL53L3CX::VL53L3CX_start_test(
  uint8_t       test_mode__ctrl)
{

	return  VL53LX_start_test(Dev,test_mode__ctrl);

}
VL53LX_Error VL53L3CX::VL53L3CX_set_firmware_enable_register(uint8_t  value)
{
	
	return  VL53LX_set_firmware_enable_register(Dev,value);

}

VL53LX_Error VL53L3CX::VL53L3CX_enable_firmware()
{
	
	return  VL53LX_enable_firmware(Dev);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_disable_firmware()
{
	return VL53LX_disable_firmware(Dev);
}


VL53LX_Error VL53L3CX::VL53L3CX_set_powerforce_register(
  uint8_t       value)
{

  return VL53LX_set_powerforce_register(Dev, value);
  
}


VL53LX_Error VL53L3CX::VL53L3CX_enable_powerforce()
{

  return VL53LX_enable_powerforce(Dev);
  
}

VL53LX_Error VL53L3CX::VL53L3CX_disable_powerforce()
{

  return VL53LX_disable_powerforce(Dev);
  
}

VL53LX_Error VL53L3CX::VL53L3CX_clear_interrupt()
{

  return  VL53LX_clear_interrupt(Dev);
	
}


VL53LX_Error VL53L3CX::VL53L3CX_force_shadow_stream_count_to_zero()
{

  return VL53LX_force_shadow_stream_count_to_zero(Dev);
  
}

uint32_t VL53L3CX::VL53L3CX_calc_macro_period_us(
  uint16_t  fast_osc_frequency,
  uint8_t   VL53LX_p_005)
{

  return  VL53LX_calc_macro_period_us(
					fast_osc_frequency,
					VL53LX_p_005);
					
}

uint16_t VL53L3CX::VL53L3CX_calc_range_ignore_threshold(
  uint32_t central_rate,
  int16_t  x_gradient,
  int16_t  y_gradient,
  uint8_t  rate_mult)
{
	
	return 	VL53LX_calc_range_ignore_threshold( central_rate,
												x_gradient,
												y_gradient,
												rate_mult);


}

uint32_t VL53L3CX::VL53L3CX_calc_timeout_mclks(
  uint32_t timeout_us,
  uint32_t macro_period_us)
{
	
	return	VL53LX_calc_timeout_mclks(timeout_us, macro_period_us);
			
}
uint16_t VL53L3CX::VL53L3CX_calc_encoded_timeout(
  uint32_t timeout_us,
  uint32_t macro_period_us)
{

	return 	VL53LX_calc_encoded_timeout(timeout_us,
										macro_period_us);
}

uint32_t VL53L3CX::VL53L3CX_calc_timeout_us(
  uint32_t timeout_mclks,
  uint32_t macro_period_us)
{

	return VL53LX_calc_timeout_us(timeout_mclks,
								  macro_period_us);
			
}

uint32_t VL53L3CX::VL53L3CX_calc_crosstalk_plane_offset_with_margin(
  uint32_t     plane_offset_kcps,
  int16_t      margin_offset_kcps)
{

	return VL53LX_calc_crosstalk_plane_offset_with_margin( plane_offset_kcps,
															margin_offset_kcps);
}

uint32_t VL53L3CX::VL53L3CX_calc_decoded_timeout_us(
  uint16_t timeout_encoded,
  uint32_t macro_period_us)
{

	return	VL53LX_calc_decoded_timeout_us( timeout_encoded,
											macro_period_us);
											
}

uint16_t VL53L3CX::VL53L3CX_encode_timeout(uint32_t timeout_mclks)
{

    return VL53LX_encode_timeout(timeout_mclks);
	
}

uint32_t VL53L3CX::VL53L3CX_decode_timeout(uint16_t encoded_timeout)
{

  return VL53LX_decode_timeout(encoded_timeout);
  
}




VL53LX_Error VL53L3CX::VL53L3CX_calc_timeout_register_values(
  uint32_t                 phasecal_config_timeout_us,
  uint32_t                 mm_config_timeout_us,
  uint32_t                 range_config_timeout_us,
  uint16_t                 fast_osc_frequency,
  VL53LX_general_config_t *pgeneral,
  VL53LX_timing_config_t  *ptiming)
{
	
     return VL53LX_calc_timeout_register_values(
			phasecal_config_timeout_us,
			mm_config_timeout_us,
			range_config_timeout_us,
			fast_osc_frequency,
			pgeneral,
			ptiming);	
	

}

uint8_t VL53L3CX::VL53L3CX_encode_vcsel_period(uint8_t VL53LX_p_030)
{

  return VL53LX_encode_vcsel_period(VL53LX_p_030);
  
}

uint32_t VL53L3CX::VL53L3CX_decode_unsigned_integer(
  uint8_t  *pbuffer,
  uint8_t   no_of_bytes)
{

  return VL53LX_decode_unsigned_integer(pbuffer, no_of_bytes);
  
}


void VL53L3CX::VL53L3CX_encode_unsigned_integer(
  uint32_t  ip_value,
  uint8_t   no_of_bytes,
  uint8_t  *pbuffer)
{

    VL53LX_encode_unsigned_integer( ip_value,
								   no_of_bytes,
								   pbuffer);
								   
}

VL53LX_Error  VL53L3CX::VL53L3CX_hist_copy_and_scale_ambient_info(
  VL53LX_zone_hist_info_t       *pidata,
  VL53LX_histogram_bin_data_t   *podata)
{
	
	return VL53LX_hist_copy_and_scale_ambient_info( pidata,
													podata);


 }


void  VL53L3CX::VL53L3CX_hist_get_bin_sequence_config(
  VL53LX_histogram_bin_data_t   *pdata)
{

  VL53LX_hist_get_bin_sequence_config(Dev, pdata);
  
}


VL53LX_Error  VL53L3CX::VL53L3CX_hist_phase_consistency_check(
  VL53LX_zone_hist_info_t     *phist_prev,
  VL53LX_zone_objects_t       *prange_prev,
  VL53LX_range_results_t      *prange_curr)
{
	
	return  VL53LX_hist_phase_consistency_check(
			Dev,
			phist_prev,
			prange_prev,
			prange_curr);

}



VL53LX_Error  VL53L3CX::VL53L3CX_hist_events_consistency_check(
  uint8_t                      event_sigma,
  uint16_t                     min_effective_spad_count,
  VL53LX_zone_hist_info_t     *phist_prev,
  VL53LX_object_data_t        *prange_prev,
  VL53LX_range_data_t         *prange_curr,
  int32_t                     *pevents_tolerance,
  int32_t                     *pevents_delta,
  VL53LX_DeviceError          *prange_status)
{
	
	return	VL53LX_hist_events_consistency_check( event_sigma,
												  min_effective_spad_count,
												  phist_prev,
												  prange_prev,
												  prange_curr,
												  pevents_tolerance,
												  pevents_delta,
												  prange_status);

}


VL53LX_Error  VL53L3CX::VL53L3CX_hist_merged_pulse_check(
  int16_t                      min_max_tolerance_mm,
  VL53LX_range_data_t         *pdata,
  VL53LX_DeviceError          *prange_status)
{
	
	return VL53LX_hist_merged_pulse_check(  min_max_tolerance_mm,
											pdata,
											prange_status);

}


VL53LX_Error  VL53L3CX::VL53L3CX_hist_xmonitor_consistency_check(
  VL53LX_zone_hist_info_t     *phist_prev,
  VL53LX_zone_objects_t       *prange_prev,
  VL53LX_range_data_t         *prange_curr)
{

	return VL53LX_hist_xmonitor_consistency_check(
			Dev,
			phist_prev,
			prange_prev,
			prange_curr);
			
}

VL53LX_Error  VL53L3CX::VL53L3CX_hist_wrap_dmax(
  VL53LX_hist_post_process_config_t  *phistpostprocess,
  VL53LX_histogram_bin_data_t        *pcurrent,
  int16_t                            *pwrap_dmax_mm)
{
	
	
	return VL53LX_hist_wrap_dmax( phistpostprocess,
									pcurrent,
									pwrap_dmax_mm);
				
}


void VL53L3CX::VL53L3CX_hist_combine_mm1_mm2_offsets(
  int16_t                               mm1_offset_mm,
  int16_t                               mm2_offset_mm,
  uint8_t                               encoded_mm_roi_centre,
  uint8_t                               encoded_mm_roi_size,
  uint8_t                               encoded_zone_centre,
  uint8_t                               encoded_zone_size,
  VL53LX_additional_offset_cal_data_t  *pcal_data,
  uint8_t                              *pgood_spads,
  uint16_t                              aperture_attenuation,
  int16_t                               *prange_offset_mm)
{
	
	return 	VL53LX_hist_combine_mm1_mm2_offsets(
												mm1_offset_mm,
												mm2_offset_mm,
												encoded_mm_roi_centre,
												encoded_mm_roi_size,
												encoded_zone_centre,
												encoded_zone_size,
												pcal_data,
												pgood_spads,
												aperture_attenuation,
												prange_offset_mm);

}

VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_calc_window(
  int16_t                             target_distance_mm,
  uint16_t                            target_width_oversize,
  VL53LX_histogram_bin_data_t        *phist_bins,
  VL53LX_hist_xtalk_extract_data_t   *pxtalk_data)
{

    return 	VL53LX_hist_xtalk_extract_calc_window( target_distance_mm,
												   target_width_oversize,
												   phist_bins,
												   pxtalk_data);

}


VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_calc_event_sums(
  VL53LX_histogram_bin_data_t        *phist_bins,
  VL53LX_hist_xtalk_extract_data_t   *pxtalk_data)
{

    return 	VL53LX_hist_xtalk_extract_calc_event_sums( phist_bins, pxtalk_data);

}
VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_calc_rate_per_spad(
  VL53LX_hist_xtalk_extract_data_t   *pxtalk_data)
{

    return 	VL53LX_hist_xtalk_extract_calc_rate_per_spad( pxtalk_data );

}

VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_calc_shape(
  VL53LX_hist_xtalk_extract_data_t  *pxtalk_data,
  VL53LX_xtalk_histogram_shape_t    *pxtalk_shape)
{
	
	return 	VL53LX_hist_xtalk_extract_calc_shape( pxtalk_data, pxtalk_shape);

}



VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_shape_model(
  uint16_t                         events_per_bin,
  uint16_t                         pulse_centre,
  uint16_t                         pulse_width,
  VL53LX_xtalk_histogram_shape_t  *pxtalk_shape)
{


  VL53LX_Error  status = VL53LX_ERROR_NONE;

  uint32_t phase_start  = 0;
  uint32_t phase_stop   = 0;
  uint32_t phase_bin    = 0;

  uint32_t bin_start    = 0;
  uint32_t bin_stop     = 0;

  uint32_t  lb           = 0;
  uint16_t  VL53LX_p_018      = 0;

  pxtalk_shape->VL53LX_p_019      = 0;
  pxtalk_shape->VL53LX_p_020    = VL53LX_XTALK_HISTO_BINS;
  pxtalk_shape->VL53LX_p_021 = VL53LX_XTALK_HISTO_BINS;

  pxtalk_shape->zero_distance_phase              = pulse_centre;
  pxtalk_shape->phasecal_result__reference_phase =
    pulse_centre + (3 * 2048);


  if (pulse_centre > (pulse_width >> 1))
    phase_start = (uint32_t)pulse_centre -
                  ((uint32_t)pulse_width >> 1);
  else {
    phase_start = 0;
  }

  phase_stop = (uint32_t)pulse_centre  +
               ((uint32_t)pulse_width >> 1);


  bin_start = (phase_start / 2048);
  bin_stop  = (phase_stop  / 2048);

  for (lb = 0; lb < VL53LX_XTALK_HISTO_BINS; lb++) {
    VL53LX_p_018 = 0;


    if (lb == bin_start && lb == bin_stop) {
      VL53LX_p_018 =
        VL53LX_hist_xtalk_shape_model_interp(
          events_per_bin,
          phase_stop - phase_start);

    } else if (lb > bin_start && lb < bin_stop) {


      VL53LX_p_018 = events_per_bin;

    } else if (lb == bin_start) {


      phase_bin = (lb + 1) * 2048;
      VL53LX_p_018 =
        VL53LX_hist_xtalk_shape_model_interp(
          events_per_bin,
          (phase_bin - phase_start));

    } else if (lb == bin_stop) {


      phase_bin = lb * 2048;
      VL53LX_p_018 =
        VL53LX_hist_xtalk_shape_model_interp(
          events_per_bin,
          (phase_stop - phase_bin));
    }

    pxtalk_shape->bin_data[lb] = VL53LX_p_018;
  }


  return status;
}

uint16_t VL53L3CX::VL53L3CX_hist_xtalk_shape_model_interp(
  uint16_t      events_per_bin,
  uint32_t      phase_delta)
{
	
	return VL53LX_hist_xtalk_shape_model_interp( events_per_bin,phase_delta);

}

void VL53L3CX::VL53L3CX_spad_number_to_byte_bit_index(
  uint8_t  spad_number,
  uint8_t *pbyte_index,
  uint8_t *pbit_index,
  uint8_t *pbit_mask)
{
		VL53LX_spad_number_to_byte_bit_index(
			spad_number,
			pbyte_index,
			pbit_index,
			pbit_mask);

}

void VL53L3CX::VL53L3CX_encode_row_col(
  uint8_t  row,
  uint8_t  col,
  uint8_t *pspad_number)
{
	
	VL53LX_encode_row_col(row, col, pspad_number);

}
void VL53L3CX::VL53L3CX_decode_zone_size(
  uint8_t  encoded_xy_size,
  uint8_t  *pwidth,
  uint8_t  *pheight)
{

	VL53LX_decode_zone_size(encoded_xy_size, pwidth, pheight);

}

void VL53L3CX::VL53L3CX_encode_zone_size(
  uint8_t  width,
  uint8_t  height,
  uint8_t *pencoded_xy_size)
{

	VL53LX_encode_zone_size(width, height, pencoded_xy_size);

}

void VL53L3CX::VL53L3CX_decode_zone_limits(
  uint8_t   encoded_xy_centre,
  uint8_t   encoded_xy_size,
  int16_t  *px_ll,
  int16_t  *py_ll,
  int16_t  *px_ur,
  int16_t  *py_ur)
{

	VL53LX_decode_zone_limits(
		encoded_xy_centre,
		encoded_xy_size,
		px_ll,
		py_ll,
		px_ur,
		py_ur);

}

uint8_t VL53L3CX::VL53L3CX_is_aperture_location(
  uint8_t row,
  uint8_t col)
{
	
	return VL53LX_is_aperture_location( row, col);

}

void VL53L3CX::VL53L3CX_calc_max_effective_spads(
  uint8_t     encoded_zone_centre,
  uint8_t     encoded_zone_size,
  uint8_t    *pgood_spads,
  uint16_t    aperture_attenuation,
  uint16_t   *pmax_effective_spads)
{
	
	VL53LX_calc_max_effective_spads(encoded_zone_centre,
									encoded_zone_size,
									pgood_spads,
									aperture_attenuation,
									pmax_effective_spads);

}




void VL53L3CX::VL53L3CX_calc_mm_effective_spads(
  uint8_t     encoded_mm_roi_centre,
  uint8_t     encoded_mm_roi_size,
  uint8_t     encoded_zone_centre,
  uint8_t     encoded_zone_size,
  uint8_t    *pgood_spads,
  uint16_t    aperture_attenuation,
  uint16_t   *pmm_inner_effective_spads,
  uint16_t   *pmm_outer_effective_spads)
{

	VL53LX_calc_mm_effective_spads( encoded_mm_roi_centre,
									encoded_mm_roi_size,
									encoded_zone_centre,
									encoded_zone_size,
									pgood_spads,
									aperture_attenuation,
									pmm_inner_effective_spads,
									pmm_outer_effective_spads);
		
}


void VL53L3CX::VL53L3CX_hist_copy_results_to_sys_and_core(
  VL53LX_histogram_bin_data_t      *pbins,
  VL53LX_range_results_t           *phist,
  VL53LX_system_results_t          *psys,
  VL53LX_core_results_t            *pcore)
{

	return VL53LX_hist_copy_results_to_sys_and_core(pbins,
													phist,
													psys,
													pcore);
													
				
}





VL53LX_Error VL53L3CX::VL53L3CX_save_cfg_data()
{
	
	return VL53LX_save_cfg_data(Dev);

}


VL53LX_Error VL53L3CX::VL53L3CX_dynamic_zone_update(
  VL53LX_range_results_t *presults)
{
	
	return	VL53LX_dynamic_zone_update(Dev, presults);

}

VL53LX_Error VL53L3CX::VL53L3CX_multizone_hist_bins_update()
{

   return VL53LX_multizone_hist_bins_update(Dev);
   
}

VL53LX_Error VL53L3CX::VL53L3CX_update_internal_stream_counters(
  uint8_t     external_stream_count,
  uint8_t    *pinternal_stream_count,
  uint8_t    *pinternal_stream_count_val)
{


    return  VL53LX_update_internal_stream_counters( Dev,
													external_stream_count,
													pinternal_stream_count,
													pinternal_stream_count_val);

}


VL53LX_Error VL53L3CX::VL53L3CX_set_histogram_multizone_initial_bin_config(
  VL53LX_zone_config_t    *pzone_cfg,
  VL53LX_histogram_config_t *phist_cfg,
  VL53LX_histogram_config_t *pmulti_hist)
{
	
	return  VL53LX_set_histogram_multizone_initial_bin_config(pzone_cfg,
															  phist_cfg,
															  pmulti_hist);
		 
}

uint8_t VL53L3CX::VL53L3CX_encode_GPIO_interrupt_config(
  VL53LX_GPIO_interrupt_config_t  *pintconf)
{
	
	return  VL53LX_encode_GPIO_interrupt_config(pintconf);

}

VL53LX_GPIO_interrupt_config_t VL53L3CX::VL53L3CX_decode_GPIO_interrupt_config(
  uint8_t   system__interrupt_config)
{
	
	return  VL53LX_decode_GPIO_interrupt_config( system__interrupt_config);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_GPIO_distance_threshold(
  uint16_t      threshold_high,
  uint16_t      threshold_low)
{
	
	return 	VL53LX_set_GPIO_distance_threshold( Dev,
												threshold_high,
												threshold_low);

}


VL53LX_Error VL53L3CX::VL53L3CX_set_GPIO_rate_threshold(
  uint16_t      threshold_high,
  uint16_t      threshold_low)
{
	
	return 	VL53LX_set_GPIO_rate_threshold( Dev,
											threshold_high,
											threshold_low);
				
}

VL53LX_Error VL53L3CX::VL53L3CX_set_GPIO_thresholds_from_struct(
  VL53LX_GPIO_interrupt_config_t *pintconf)
{
	
	  return  VL53LX_set_GPIO_thresholds_from_struct( Dev, pintconf);	
}


VL53LX_Error VL53L3CX::VL53L3CX_set_ref_spad_char_config(
  uint8_t       vcsel_period_a,
  uint32_t      phasecal_timeout_us,
  uint16_t      total_rate_target_mcps,
  uint16_t      max_count_rate_rtn_limit_mcps,
  uint16_t      min_count_rate_rtn_limit_mcps,
  uint16_t      fast_osc_frequency)
{
	
	return 	VL53LX_set_ref_spad_char_config(Dev,
											vcsel_period_a,
											phasecal_timeout_us,
											total_rate_target_mcps,
											max_count_rate_rtn_limit_mcps,
											min_count_rate_rtn_limit_mcps,
											fast_osc_frequency);

}

VL53LX_Error VL53L3CX::VL53L3CX_set_ssc_config(
  VL53LX_ssc_config_t  *pssc_cfg,
  uint16_t              fast_osc_frequency)
{
	
	return VL53LX_set_ssc_config( Dev,
								  pssc_cfg,
								  fast_osc_frequency);


}


VL53LX_Error VL53L3CX::VL53L3CX_get_spad_rate_data(
  VL53LX_spad_rate_data_t  *pspad_rates)
{
	
	return  VL53LX_get_spad_rate_data( Dev, pspad_rates);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_calc_required_samples()
{
	
	return VL53LX_dynamic_xtalk_correction_calc_required_samples( Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_calc_new_xtalk(
  uint32_t        xtalk_offset_out,
  VL53LX_smudge_corrector_config_t  *pconfig,
  VL53LX_smudge_corrector_data_t    *pout,
  uint8_t         add_smudge,
  uint8_t         soft_update
)
{
	
	return  VL53LX_dynamic_xtalk_correction_calc_new_xtalk(	Dev, xtalk_offset_out, pconfig, pout,add_smudge,soft_update);
}



VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_corrector()
{
	
	return  VL53LX_dynamic_xtalk_correction_corrector( Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_data_init()
{
	return  VL53LX_dynamic_xtalk_correction_data_init( Dev);
}


VL53LX_Error VL53L3CX::VL53L3CX_dynamic_xtalk_correction_output_init(
  VL53LX_LLDriverResults_t *pres
)
{
	
	return VL53LX_dynamic_xtalk_correction_output_init(pres);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_xtalk_cal_data_init()
{
	
    return  VL53LX_xtalk_cal_data_init( Dev );

}

VL53LX_Error VL53L3CX::VL53L3CX_low_power_auto_data_init()
{
	
	return  VL53LX_low_power_auto_data_init( Dev);
	
}

VL53LX_Error VL53L3CX::VL53L3CX_low_power_auto_data_stop_range()
{
	
	return VL53LX_low_power_auto_data_stop_range(Dev);

}

VL53LX_Error VL53L3CX::VL53L3CX_config_low_power_auto_mode(
  VL53LX_general_config_t   *pgeneral,
  VL53LX_dynamic_config_t   *pdynamic,
  VL53LX_low_power_auto_data_t *plpadata
)
{
	
    return  VL53LX_config_low_power_auto_mode( pgeneral, pdynamic,plpadata);

}


VL53LX_Error VL53L3CX::VL53L3CX_low_power_auto_setup_manual_calibration()
{
	
	return VL53LX_low_power_auto_setup_manual_calibration( Dev);
}


VL53LX_Error VL53L3CX::VL53L3CX_low_power_auto_update_DSS()
{

    return  VL53LX_low_power_auto_update_DSS( Dev );

}

VL53LX_Error VL53L3CX::VL53L3CX_compute_histo_merge_nb(uint8_t *histo_merge_nb)
{
	
	return  VL53LX_compute_histo_merge_nb( Dev,	histo_merge_nb);
	
}

/* vl53lx_wait.c */


VL53LX_Error VL53L3CX::VL53L3CX_wait_for_boot_completion()
{
	
	return VL53LX_wait_for_boot_completion(Dev);

}

VL53LX_Error VL53L3CX::VL53L3CX_wait_for_firmware_ready()
{
	
	return VL53LX_wait_for_firmware_ready(Dev);

}


VL53LX_Error VL53L3CX::VL53L3CX_wait_for_range_completion()
{
	
	return VL53LX_wait_for_range_completion(Dev);

}
VL53LX_Error VL53L3CX::VL53L3CX_wait_for_test_completion()
{
    return VL53LX_wait_for_test_completion(Dev);
}

VL53LX_Error VL53L3CX::VL53L3CX_is_boot_complete(
  uint8_t       *pready)
{
	
	return VL53LX_is_boot_complete( Dev,
									pready);
				
}

VL53LX_Error VL53L3CX::VL53L3CX_is_firmware_ready(
  uint8_t       *pready)
{
	
	return VL53LX_is_firmware_ready( Dev, pready);

}
VL53LX_Error VL53L3CX::VL53L3CX_is_new_data_ready(
  uint8_t       *pready)
{
	
	return VL53LX_is_new_data_ready(Dev, pready);

}

VL53LX_Error VL53L3CX::VL53L3CX_poll_for_boot_completion(
  uint32_t      timeout_ms)
{

   return VL53LX_poll_for_boot_completion(Dev,timeout_ms);
   
}

VL53LX_Error VL53L3CX::VL53L3CX_poll_for_firmware_ready(
  uint32_t      timeout_ms)
{
	
	 return VL53LX_poll_for_firmware_ready(Dev,timeout_ms);

}

VL53LX_Error VL53L3CX::VL53L3CX_poll_for_range_completion(
  uint32_t       timeout_ms)
{
	
	return VL53LX_poll_for_range_completion(Dev, timeout_ms);
	
}

/* vl53lx_zone_presets.c */


VL53LX_Error VL53L3CX::VL53L3CX_init_zone_config_histogram_bins(
  VL53LX_zone_config_t   *pdata)
{

	return  VL53LX_init_zone_config_histogram_bins(pdata);
	
}

/* vl53lx_api_preset_modes.h */

VL53LX_Error VL53L3CX::VL53L3CX_init_refspadchar_config_struct(
  VL53LX_refspadchar_config_t   *pdata)
{
	
	return VL53LX_init_refspadchar_config_struct(pdata);
			
}

VL53LX_Error VL53L3CX::VL53L3CX_init_ssc_config_struct(
  VL53LX_ssc_config_t   *pdata)
{
	
	return VL53LX_init_ssc_config_struct(pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_init_xtalk_config_struct(
  VL53LX_customer_nvm_managed_t *pnvm,
  VL53LX_xtalk_config_t   *pdata)
{
	
	return VL53LX_init_xtalk_config_struct(
			pnvm,
			pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_init_xtalk_extract_config_struct(
  VL53LX_xtalkextract_config_t   *pdata)
{
	
	return VL53LX_init_xtalk_extract_config_struct(pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_init_offset_cal_config_struct(
  VL53LX_offsetcal_config_t   *pdata)
{
	
	return  VL53LX_init_offset_cal_config_struct(pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_init_zone_cal_config_struct(
  VL53LX_zonecal_config_t   *pdata)
{
	
	return VL53LX_init_zone_cal_config_struct(pdata);

}

VL53LX_Error VL53L3CX::VL53L3CX_init_hist_post_process_config_struct(
  uint8_t                             xtalk_compensation_enable,
  VL53LX_hist_post_process_config_t   *pdata)
{
	
	return  VL53LX_init_hist_post_process_config_struct(
			xtalk_compensation_enable,
			pdata);

}


VL53LX_Error VL53L3CX::VL53L3CX_init_dmax_calibration_data_struct(
  VL53LX_dmax_calibration_data_t   *pdata)
{
	
	return VL53LX_init_dmax_calibration_data_struct( pdata );

}

VL53LX_Error VL53L3CX::VL53L3CX_init_tuning_parm_storage_struct(
  VL53LX_tuning_parm_storage_t   *pdata)
{
	
	return  VL53LX_init_tuning_parm_storage_struct( pdata );
			
}

VL53LX_Error VL53L3CX::VL53L3CX_init_hist_gen3_dmax_config_struct(
  VL53LX_hist_gen3_dmax_config_t   *pdata)
{
    return VL53LX_init_hist_gen3_dmax_config_struct( pdata);
}


VL53LX_Error VL53L3CX::VL53L3CX_preset_mode_standard_ranging(
  VL53LX_static_config_t    *pstatic,
  VL53LX_histogram_config_t *phistogram,
  VL53LX_general_config_t   *pgeneral,
  VL53LX_timing_config_t    *ptiming,
  VL53LX_dynamic_config_t   *pdynamic,
  VL53LX_system_control_t   *psystem,
  VL53LX_tuning_parm_storage_t *ptuning_parms,
  VL53LX_zone_config_t      *pzone_cfg)
{
	
	
	return VL53LX_preset_mode_standard_ranging(
			pstatic,
			phistogram,
			pgeneral,
			ptiming,
			pdynamic,
			psystem,
			ptuning_parms,
			pzone_cfg);
}

VL53LX_Error VL53L3CX::VL53L3CX_preset_mode_histogram_ranging(
  VL53LX_hist_post_process_config_t  *phistpostprocess,
  VL53LX_static_config_t             *pstatic,
  VL53LX_histogram_config_t          *phistogram,
  VL53LX_general_config_t            *pgeneral,
  VL53LX_timing_config_t             *ptiming,
  VL53LX_dynamic_config_t            *pdynamic,
  VL53LX_system_control_t            *psystem,
  VL53LX_tuning_parm_storage_t       *ptuning_parms,
  VL53LX_zone_config_t               *pzone_cfg)
{
	
	return 	VL53LX_preset_mode_histogram_ranging(   phistpostprocess,
													pstatic,
													phistogram,
													pgeneral,
													ptiming,
													pdynamic,
													psystem,
													ptuning_parms,
													pzone_cfg);
			
}


VL53LX_Error VL53L3CX::VL53L3CX_preset_mode_histogram_long_range(
  VL53LX_hist_post_process_config_t  *phistpostprocess,
  VL53LX_static_config_t             *pstatic,
  VL53LX_histogram_config_t          *phistogram,
  VL53LX_general_config_t            *pgeneral,
  VL53LX_timing_config_t             *ptiming,
  VL53LX_dynamic_config_t            *pdynamic,
  VL53LX_system_control_t            *psystem,
  VL53LX_tuning_parm_storage_t       *ptuning_parms,
  VL53LX_zone_config_t               *pzone_cfg)
{
	
	return VL53LX_preset_mode_histogram_long_range( phistpostprocess,
													pstatic,
													phistogram,
													pgeneral,
													ptiming,
													pdynamic,
													psystem,
													ptuning_parms,
													pzone_cfg);

}



VL53LX_Error VL53L3CX::VL53L3CX_preset_mode_histogram_medium_range(
  VL53LX_hist_post_process_config_t  *phistpostprocess,
  VL53LX_static_config_t             *pstatic,
  VL53LX_histogram_config_t          *phistogram,
  VL53LX_general_config_t            *pgeneral,
  VL53LX_timing_config_t             *ptiming,
  VL53LX_dynamic_config_t            *pdynamic,
  VL53LX_system_control_t            *psystem,
  VL53LX_tuning_parm_storage_t       *ptuning_parms,
  VL53LX_zone_config_t               *pzone_cfg)
{
	
	
	return 	VL53LX_preset_mode_histogram_medium_range(  phistpostprocess,
														pstatic,
														phistogram,
														pgeneral,
														ptiming,
														pdynamic,
														psystem,
														ptuning_parms,
														pzone_cfg);

}


VL53LX_Error VL53L3CX::VL53L3CX_preset_mode_histogram_short_range(
  VL53LX_hist_post_process_config_t  *phistpostprocess,
  VL53LX_static_config_t             *pstatic,
  VL53LX_histogram_config_t          *phistogram,
  VL53LX_general_config_t            *pgeneral,
  VL53LX_timing_config_t             *ptiming,
  VL53LX_dynamic_config_t            *pdynamic,
  VL53LX_system_control_t            *psystem,
  VL53LX_tuning_parm_storage_t       *ptuning_parms,
  VL53LX_zone_config_t               *pzone_cfg)
{


	return VL53LX_preset_mode_histogram_short_range(phistpostprocess,
													pstatic,
													phistogram,
													pgeneral,
													ptiming,
													pdynamic,
													psystem,
													ptuning_parms,
													pzone_cfg);

}





void VL53L3CX::VL53L3CX_copy_hist_bins_to_static_cfg(
  VL53LX_histogram_config_t *phistogram,
  VL53LX_static_config_t    *pstatic,
  VL53LX_timing_config_t    *ptiming)
{
	
	return 	VL53LX_copy_hist_bins_to_static_cfg(phistogram,
												pstatic,
												ptiming);

}


/* vl53lx_silicon_core.c */

VL53LX_Error VL53L3CX::VL53L3CX_is_firmware_ready_silicon(
  uint8_t       *pready)
{

    return  VL53LX_is_firmware_ready_silicon( Dev, pready);

}

/* vl53lx_hist_core.c */


/* vl53lx_xtalk.c */


VL53LX_Error VL53L3CX::VL53L3CX_xtalk_calibration_process_data(
  VL53LX_xtalk_range_results_t    *pxtalk_results,
  VL53LX_xtalk_histogram_data_t   *pxtalk_shape,
  VL53LX_xtalk_calibration_results_t  *pxtalk_cal)
{
	
	return 	VL53LX_xtalk_calibration_process_data(  pxtalk_results,
													pxtalk_shape,
													pxtalk_cal);

}




/* vl53lx_sigma_estimate.c */



/* vl53lx_hist_algos_gen3.c */





/* vl53lx_hist_algos_gen4.c */





/* vl53lx_dmax.c */





/* vl53lx_api_calibration.c */


VL53LX_Error VL53L3CX::VL53L3CX_run_ref_spad_char(
  VL53LX_Error     *pcal_status)
{
    return  VL53LX_run_ref_spad_char(Dev, pcal_status);
}


VL53LX_Error VL53L3CX::VL53L3CX_get_and_avg_xtalk_samples(
  uint8_t                       num_of_samples,
  uint8_t                       measurement_mode,
  int16_t                       xtalk_filter_thresh_max_mm,
  int16_t                       xtalk_filter_thresh_min_mm,
  uint16_t                      xtalk_max_valid_rate_kcps,
  uint8_t                       xtalk_result_id,
  uint8_t                       xtalk_histo_id,
  VL53LX_xtalk_range_results_t *pXR,
  VL53LX_histogram_bin_data_t  *psum_histo,
  VL53LX_histogram_bin_data_t  *pavg_histo)
{
	
	return VL53LX_get_and_avg_xtalk_samples( Dev,
		                                     num_of_samples,
		                                     measurement_mode,
		                                     xtalk_filter_thresh_max_mm,
		                                     xtalk_filter_thresh_min_mm,
		                                     xtalk_max_valid_rate_kcps,
		                                     xtalk_result_id,
		                                     xtalk_histo_id,
	                                     	 pXR,
		                                     psum_histo,
	                                    	 pavg_histo);

}



VL53LX_Error VL53L3CX::VL53L3CX_run_device_test(
  VL53LX_DeviceTestMode  device_test_mode)
{
	return  VL53LX_run_device_test( Dev, device_test_mode);
}

void VL53L3CX::VL53L3CX_hist_xtalk_extract_data_init(
  VL53LX_hist_xtalk_extract_data_t *pxtalk_data)
{

	VL53LX_hist_xtalk_extract_data_init(pxtalk_data);

}

VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_update(
  int16_t                             target_distance_mm,
  uint16_t                            target_width_oversize,
  VL53LX_histogram_bin_data_t        *phist_bins,
  VL53LX_hist_xtalk_extract_data_t   *pxtalk_data)
{
	
	return 	VL53LX_hist_xtalk_extract_update(target_distance_mm,
											 target_width_oversize,
											 phist_bins,
											 pxtalk_data);
						
}


VL53LX_Error VL53L3CX::VL53L3CX_hist_xtalk_extract_fini(
  VL53LX_histogram_bin_data_t        *phist_bins,
  VL53LX_hist_xtalk_extract_data_t   *pxtalk_data,
  VL53LX_xtalk_calibration_results_t *pxtalk_cal,
  VL53LX_xtalk_histogram_shape_t     *pxtalk_shape)
{
	
	return 	VL53LX_hist_xtalk_extract_fini( phist_bins,
											pxtalk_data,
											pxtalk_cal,
											pxtalk_shape);

}


VL53LX_Error   VL53L3CX::VL53L3CX_run_hist_xtalk_extraction(
  int16_t                             cal_distance_mm,
  VL53LX_Error                       *pcal_status)
{
	return  VL53LX_run_hist_xtalk_extraction(Dev, cal_distance_mm, pcal_status);
}

/* vl53lx_api.c */

VL53LX_Error VL53L3CX::VL53L3CX_GetVersion(VL53LX_Version_t *pVersion)
{
    return VL53LX_GetVersion( pVersion);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetProductRevision(
  uint8_t *pProductRevisionMajor, uint8_t *pProductRevisionMinor)
{
    return VL53LX_GetProductRevision( Dev,
									  pProductRevisionMajor, 
									  pProductRevisionMinor);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetDeviceInfo(
  VL53LX_DeviceInfo_t *pVL53LX_DeviceInfo)
{
    return VL53LX_GetDeviceInfo( Dev,pVL53LX_DeviceInfo);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetUID(uint64_t *pUid)
{
    return VL53LX_GetUID( Dev, pUid);
}
/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetDeviceAddress(uint8_t DeviceAddress)
{
    return VL53LX_SetDeviceAddress(Dev, DeviceAddress);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_DataInit()
{
    return VL53LX_DataInit(Dev);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_WaitDeviceBooted()
{
    return VL53LX_WaitDeviceBooted(Dev);
}


/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetDistanceMode(
  VL53LX_DistanceModes DistanceMode)
{
	
	return VL53LX_SetDistanceMode(Dev, DistanceMode);
	
}
/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetDistanceMode(
  VL53LX_DistanceModes *pDistanceMode)
{
  return VL53LX_GetDistanceMode(Dev, pDistanceMode);;
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetMeasurementTimingBudgetMicroSeconds(
  uint32_t MeasurementTimingBudgetMicroSeconds)
{
	
	return VL53LX_SetMeasurementTimingBudgetMicroSeconds(Dev,
				MeasurementTimingBudgetMicroSeconds);
  
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetMeasurementTimingBudgetMicroSeconds(
  uint32_t *pMeasurementTimingBudgetMicroSeconds)
{
  return VL53LX_GetMeasurementTimingBudgetMicroSeconds(Dev,pMeasurementTimingBudgetMicroSeconds);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_StartMeasurement()
{
  return VL53LX_StartMeasurement(Dev);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_StopMeasurement()
{
  return VL53LX_StopMeasurement(Dev);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_ClearInterruptAndStartMeasurement()
{
  return VL53LX_ClearInterruptAndStartMeasurement(Dev);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetMeasurementDataReady(uint8_t *pMeasurementDataReady)
{
    return VL53LX_GetMeasurementDataReady(Dev, pMeasurementDataReady);
}
/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_WaitMeasurementDataReady()
{
	return VL53LX_WaitMeasurementDataReady(Dev);
}



/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetMultiRangingData(
  VL53LX_MultiRangingData_t *pMultiRangingData)
{
	
	return VL53LX_GetMultiRangingData(Dev, pMultiRangingData);
	
}
/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetAdditionalData(VL53LX_AdditionalData_t *pAdditionalData)
{
    return VL53LX_GetAdditionalData( Dev,pAdditionalData);
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetTuningParameter(
  uint16_t TuningParameterId, int32_t TuningParameterValue)
{
	
	return VL53LX_SetTuningParameter( Dev, TuningParameterId,  TuningParameterValue);
		
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetTuningParameter(
  uint16_t TuningParameterId, int32_t *pTuningParameterValue)
{

	return VL53LX_GetTuningParameter( Dev, TuningParameterId, pTuningParameterValue);
	
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_PerformRefSpadManagement()
{
	
	return VL53LX_PerformRefSpadManagement(Dev);
	
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SmudgeCorrectionEnable(
  VL53LX_SmudgeCorrectionModes Mode)
{
	
	return VL53LX_SmudgeCorrectionEnable(Dev, Mode);

}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetXTalkCompensationEnable(
  uint8_t XTalkCompensationEnable)
{
	
	return VL53LX_SetXTalkCompensationEnable( Dev, XTalkCompensationEnable );

}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetXTalkCompensationEnable(
  uint8_t *pXTalkCompensationEnable)
{
	
	return VL53LX_GetXTalkCompensationEnable( Dev,pXTalkCompensationEnable);

}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_PerformXTalkCalibration()
{
	
    return  VL53LX_PerformXTalkCalibration( Dev);
  
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetOffsetCorrectionMode(
  VL53LX_OffsetCorrectionModes OffsetCorrectionMode)
{
	
	return VL53LX_SetOffsetCorrectionMode(Dev, OffsetCorrectionMode);
	
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_PerformOffsetSimpleCalibration(
  int32_t CalDistanceMilliMeter)
{
	
	return VL53LX_PerformOffsetSimpleCalibration(Dev, CalDistanceMilliMeter);
	
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_PerformOffsetZeroDistanceCalibration()
{
	
	return VL53LX_PerformOffsetZeroDistanceCalibration( Dev );
	
}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_SetCalibrationData(
  VL53LX_CalibrationData_t *pCalibrationData)
{
	
	return VL53LX_SetCalibrationData(Dev, pCalibrationData);

}

/* vl53lx_api.c */
VL53LX_Error VL53L3CX::VL53L3CX_GetCalibrationData(
  VL53LX_CalibrationData_t  *pCalibrationData)
{
	
	return 	VL53LX_GetCalibrationData(Dev,pCalibrationData);

}


VL53LX_Error VL53L3CX::VL53L3CX_PerformOffsetPerVcselCalibration(
  int32_t CalDistanceMilliMeter)
{
	
	return  VL53LX_PerformOffsetPerVcselCalibration( Dev, CalDistanceMilliMeter);
	
}

