/**
 ******************************************************************************
 * @file    VL53L3A2_RangingClass.h
 * @author  CGM
 * @version V0.0.1
 * @date    5/7/2021
 * @brief   Header file for class VL53L3A2_SENSOR
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2021 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

#ifndef __VL53L3A2_SENSOR_CLASS_H
#define __VL53L3A2_SENSOR_CLASS_H


/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "PinNames.h"


/* Includes ------------------------------------------------------------------*/
#include "53l3a2_conf.h"
#include "stdint.h"
#include "53l3a2_ranging_sensor.h"

/* Classes--------------------------------------------------------------------*/

/* Classes -------------------------------------------------------------------*/
/** Class representing the VL53L3A2 SENSOR
 */
class VL53L3A2_SENSOR
{
public:
    /** Constructor 1
    */
    VL53L3A2_SENSOR()
    {
        

    }  
    

    
    /** Destructor
     */
    ~VL53L3A2_SENSOR()
    {
        printf("XNucleo53L3A2 destructor \n");

    }
	
	int32_t VL53L3A2_RANGING_Init(uint32_t Instance);
	int32_t VL53L3A2_RANGING_DeInit(uint32_t Instance);
	int32_t VL53L3A2_RANGING_ReadID(uint32_t Instance, uint32_t *pId);
	int32_t VL53L3A2_RANGING_GetCapabilities(uint32_t Instance, RANGING_SENSOR_Capabilities_t *pCapabilities);
	int32_t VL53L3A2_RANGING_ConfigProfile(uint32_t Instance, RANGING_SENSOR_ProfileConfig_t *pConfig);
	int32_t VL53L3A2_RANGING_ConfigROI(uint32_t Instance, RANGING_SENSOR_ROIConfig_t *pConfig);
	int32_t VL53L3A2_RANGING_ConfigIT(uint32_t Instance, RANGING_SENSOR_ITConfig_t *pConfig);
	int32_t VL53L3A2_RANGING_GetDistance(uint32_t Instance, RANGING_SENSOR_Result_t *pResult);
	int32_t VL53L3A2_RANGING_Start(uint32_t Instance, uint32_t Mode);
	int32_t VL53L3A2_RANGING_Stop(uint32_t Instance);
	int32_t VL53L3A2_RANGING_SetAddress(uint32_t Instance, uint32_t Address);
	int32_t VL53L3A2_RANGING_GetAddress(uint32_t Instance, uint32_t *pAddress);
	int32_t VL53L3A2_RANGING_SetPowerMode(uint32_t Instance, uint32_t PowerMode);
	int32_t VL53L3A2_RANGING_GetPowerMode(uint32_t Instance, uint32_t *pPowerMode);

	int32_t VL53L3A2_RANGING_OffsetCalibration(uint32_t Instance, uint32_t CalDistance);
	int32_t VL53L3A2_RANGING_XTalkCalibration(uint32_t Instance);

};


#endif /* __VL53L3A2_SENSOR_CLASS_H */
