/**
  ******************************************************************************
  * @file    53l3a2.h
  * @author  IMG SW Application Team
  * @brief   This file contains the common defines and functions prototypes for
  *          the 53l3a2.c driver.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef XNUCLEO_53L3A2_H
#define XNUCLEO_53L3A2_H

/* Includes ------------------------------------------------------------------*/
#include "53l3a2_conf.h"
#include "stdint.h"

/** @addtogroup BSP
  * @{
  */

/** @defgroup XNUCLEO_53L3A2 X-NUCLEO-53L3A2
  * @{
  */

/** @defgroup XNUCLEO_53L3A2_COMMON COMMON
  * @{
  */

/* XNUCLEO-53L3A2 Device selector */
enum VL53L3A2_dev_e
{
  VL53L3A2_DEV_LEFT    =  0,   /* !< left satellite device P21 header */
  VL53L3A2_DEV_CENTER  =  1,   /* !< center (built-in) device */
  VL53L3A2_DEV_RIGHT   =  2    /* !< Right satellite device P22 header */
};

/** @defgroup XNUCLEO_53L3A2_COMMON_Exported_Functions Exported Functions
  * @{
  */
int32_t VL53L3A2_Init(void);
int32_t VL53L3A2_DeInit(void);
int32_t VL53L3A2_ResetId(uint8_t DevNo,  uint8_t state);
int32_t VL53L3A2_SetDisplayString(const char *str);


#endif /* XNUCLEO_53L3A2_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

