#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "ExperimentServer.h"
#include "QEI.h"
#include "MotorShield.h" 
#include "HardwareSetup.h"
//#include<iostream> // to use min function
//#include<algorithm>// to use min function 
//using namespace std; 

#define NUM_INPUTS  5
#define NUM_OUTPUTS 5
#define DT 0.001


#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

#define Vnom           12.0


Serial pc(USBTX, USBRX);    // USB Serial Terminal
ExperimentServer server;    // Object that lets us communicate with MATLAB
Timer t;                    // Timer to measure elapsed time of experiment

QEI encoderA(PE_9,PE_11, NC, 1200, QEI::X4_ENCODING);  // MOTOR A ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderB(PA_5, PB_3, NC, 1200, QEI::X4_ENCODING);  // MOTOR B ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderC(PC_6, PC_7, NC, 1200, QEI::X4_ENCODING);  // MOTOR C ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderD(PD_12, PD_13, NC, 1200, QEI::X4_ENCODING);// MOTOR D ENCODER (no index, 1200 counts/rev, Quadrature encoding)

MotorShield motorShield(12000); //initialize the motor shield with a period of 12000 clock ticks or ~20kHZ

int main (void)
{
    // Link the terminal with our server and start it up
    server.attachTerminal(pc);
    server.init();
    float V; //input voltage
    float d; // duty cycle
    float error;
    float last_error=0;
    float sum_error=0;
    float duration =3;
    int cst;
    // Continually get input from MATLAB and run experiments
    float input_params[NUM_INPUTS];
    pc.printf("%f",input_params[0]);
    
    while(1) {
        if (server.getParams(input_params,NUM_INPUTS)) {
            float theta_d   = input_params[0]; // desired angle degrees
            float Kp   = input_params[1]; // Kp
            float Kd   = input_params[2]; // Kp
            float Ki   = input_params[3]; // Kp
            float duration = input_params[4]; //
            int dir;

            // Setup experiment
            t.reset();
            t.start();
            encoderA.reset();
            encoderB.reset();
            encoderC.reset();
            encoderD.reset();

            motorShield.motorAWrite(0, 0); //turn motor A off
            
            //use the motor shield as follows:
            //motorShield.motorAWrite(DUTY CYCLE, DIRECTION), DIRECTION = 0 is forward, DIRECTION =1 is backwards.
             
            // Run experiment
            
            
            /*while( t.read() < 2 ) {
                // Perform control loop logic
                if (t.read() < 1)
                    motorShield.motorAWrite(0.5, 0); //run motor A at "v1" duty cycle and in the forward direction 
                else
                    motorShield.motorAWrite(0.5, 1); //run motor A at "v2" duty cycle and in the forward direction */

                // Form output to send to MATLAB
                float output_data[NUM_OUTPUTS];
    /*            output_data[0] = t.read();
                output_data[1] = encoderA.getPulses()*2*M_PI/1200; //MODIFY: COPY IN YOUR ANSWER FROM PART 1
                output_data[2] = encoderA.getVelocity()*2*M_PI/1200; //MODIFY: COPY IN YOUR ANSWER FROM PART 1
                output_data[3] = motorShield.readCurrentA()*(30.0/65536.0)-15;
                output_data[4] = V_nom*0.5;*/
                
                
                
                
                  while( t.read() < duration ) {
                    output_data[0] = t.read();
                    output_data[1] = encoderA.getPulses()*2*M_PI/1200; //MODIFY: COPY IN YOUR ANSWER FROM PART 1
                    output_data[2] = encoderA.getVelocity()*2*M_PI/1200; //MODIFY: COPY IN YOUR ANSWER FROM PART 1
                    output_data[3] = motorShield.readCurrentA()*(30.0/65536.0)-15;
                    
                    
                    error = (theta_d-output_data[1]);
                    
                    
                    V = Kp*error + Kd*(error-last_error)/DT + Ki*sum_error; //(-output_data[2]); //PID controller gives voltage to apply
                    //output_data[4] = V;
                    last_error = error;
                    sum_error += error;
                    // convert to duty cycle
                    if (V>0){
                        dir = 0;
                        d = V/Vnom;
                        cst=1;
                        }
                    else { // V<=0;
                        dir = 1;
                        d = -V/Vnom;// make sure this is positive
                        cst = -1;
                        //
                        }
                    
                    if (d>=1){
                        d=1;
                        }
                        
                  
                    output_data[4]=d*Vnom*cst;
                    //d = std::min(d,1) // ceil the value of the duty cycle;
                    
                // Perform control loop logic
                     //if (t.read() < 1)
                        motorShield.motorAWrite(d, dir); //run motor A at "v1" duty cycle and in the forward direction 
                    // else
                        

                
                
                
                // Send data to MATLAB
                server.sendData(output_data,NUM_OUTPUTS);
                
                wait(DT); //run control loop at 1kHz
            }
            // Cleanup after experiment
            server.setExperimentComplete();
            motorShield.motorAWrite(0, 0); //turn motor A off
        } // end if
    } // end while
    
} // end main

