/**
 * @author Charles Young
 *
 */

#include "LED7segDisplay.hpp"

LED7segDisplay::LED7segDisplay()
{
   brightness = BRIGHTNESS_MAX;
   Display_init();
}

//---------------------------------------------------------------------------
// Initialize the MAX7219

void LED7segDisplay::Display_init(void)
{
   uint8_t i;
   uint16_t data_to_send[6] = {SHUTDOWN, TURN_ON, DEC_MODE, brightness, SCAN_LIM, TEST};

   for(i = 0; i < sizeof(data_to_send)/sizeof(uint16_t); i++)
   {
      sendDataToDisplay(data_to_send[i]);
   }
    
   return;
}

void LED7segDisplay::Display_brightness_up()
{
   if (brightness < BRIGHTNESS_MAX)
   {
      Display_brightness(++brightness);
   }
}

void LED7segDisplay::Display_brightness_down()
{
   if (brightness > BRIGHTNESS_MIN)
   {
      Display_brightness(--brightness);
   }
}

void LED7segDisplay::Display_brightness(uint16_t brightness)
{
   sendDataToDisplay(brightness);
}

//---------------------------------------------------------------------------
// Refresh the 6 digits of the main display


//---------------------------------------------------------------------------
// Refresh the 2 digits of the gate display

void LED7segDisplay::Display_2D_Blank()
{
   uint16_t data_to_send;

   for(uint8_t digit = 7; digit < 9; digit++)
   {
      // each stream consists of digit address and data to show
      data_to_send = digit;
      data_to_send<<=8;
      data_to_send = data_to_send | 0x7F;
      sendDataToDisplay(data_to_send);
   }
}

void LED7segDisplay::Display_6D_write(int32_t value)
{
 
   uint8_t digit;
   uint16_t data_to_send;
   char TextString[6];
    
   // int to string, then string to digits
   sprintf(TextString, "%6d", value);   // int to string
    
   for(uint8_t i=0; i<6; i++)
   {   
      if(TextString[i] == ' ')  // blank empty digits
         Disp_Digit[i] = 0x7F;
      else
         Disp_Digit[i] = TextString[i]-'0';      
   }

   for(digit = 1; digit <7; digit++)
   {
      // each stream consists of digit address and data to show
      data_to_send = 7 - digit;
      data_to_send<<=8;
      data_to_send = data_to_send | Disp_Digit[digit-1];
      sendDataToDisplay(data_to_send);
   }
    
   return;
}

void LED7segDisplay::Display_2D_write(int16_t value)
{
   bool negative = false;
   if (value < 0)
      negative = true;
   value = abs(value);
   
   uint8_t digit;
   uint16_t data_to_send;
   char TextString[2];

   // int to string, then string to digits
   sprintf(TextString, "%2d", value);   // int to string

   if(TextString[0] == ' ')  // blank empty digits
      Disp_Digit[7] = 0x7F;
   else
      Disp_Digit[7] = TextString[0] - '0';
    
   Disp_Digit[6] = TextString[1] - '0';
   // turn on decimal point to indicate negative
   if (negative)
      Disp_Digit[6] |= 0x80;

   for(digit = 7; digit <9; digit++)
   {
      // each stream consists of digit address and data to show
      data_to_send = digit;
      data_to_send<<=8;
      data_to_send = data_to_send | Disp_Digit[digit-1];
      sendDataToDisplay(data_to_send);
   }
    
   return;
}

void LED7segDisplay::sendDataToDisplay(uint16_t data_to_send)
{
   CS1 = 0;
   for(uint16_t mask = 0x8000; mask!= 0; mask>>= 1)
   {
      wait_us(DT);
      SCK = 0;
      if(mask & data_to_send)
         MOSI = 1;
      else
         MOSI = 0;
                
      wait_us(DT);
      SCK = 1;
   }
        
   wait_us(DT);    
   SCK = 0;
   wait_us(DT);
   CS1 = 1;
}
