/**
 * @author Charles Young
 * This class encapsulates the behavior of the rotary switch to change modes
 */

#ifndef RotarySwitch_H
#define RotarySwitch_H

/**
 * Includes
 */
#include "mbed.h"
#include "QEI.h"        // Quadrature Encoder functions
#include "HwRegisters.hpp"

/**
 * Code associated with rotary switch.
 */
class RotarySwitch {

public:

   /**
    * Constructor.
    *
    * @param channelA mbed pin for channel A input.
    * @param channelB mbed pin for channel B input.
    */
   RotarySwitch();

   void  UpdateOutput();
   float UpdateInput();

   /**
    * Get the current position of switch.
    */
   int GetPosition(void);

private:
   static const int WheelStateTimeout = 5; //timeout for wheel button pushed

   enum WheelState {
      WHEEL_INACTIVE       = 0,
      WHEEL_MODE_SELECT    = 1,
      WHEEL_SUBMODE_SELECT = 2
   };
   enum WheelStateEvent {
      WHEEL_Pressed = 0,
      WHEEL_Timeout = 1
   };
   
   WheelState currentWheelState;
   uint8_t LED_status;
   uint8_t LED_status_index;
   static const uint8_t LED_status_index_size = 8;
   uint8_t LED_status_reported;
   int WheelCurrent;
   int WheelPrevious;
   bool QEPBpressed; // only react to button when pressed
   int WheelStateTimer;

   /**
    * Manage state machine
    */
   void WheelStateMachine(WheelStateEvent event);
   void LEDs_write(unsigned short data_val);
};

#endif /* RotarySwitch_H */
