/**
 * @author Charles Young
 * This class encapsulates the behavior of the 7-seg 8 digit LED display
 */

#ifndef LED7segDisplay_H
#define LED7segDisplay_H

/**
 * Includes
 */
#include "mbed.h"
#include "HwRegisters.hpp"

#define DEC_MODE    0x09FF  // BCD decoding on all digits
#define SCAN_LIM    0x0B07  // use all 8 digits  
#define TURN_ON     0x0C01  // no shutdown (operating)
#define SHUTDOWN    0x0C00  // shutdown
#define TEST        0x0F00  // no test
#define DT      1      // delay time in us for SPI emulation

#define BRIGHTNESS_MIN  0x0A00  // brightness in 16 steps - min to max is 0x0A00 to  0x0A0F
#define BRIGHTNESS_MAX  0x0A0F  // brightness in 16 steps - min to max is 0x0A00 to  0x0A0F

/**
 * Code associated with rotary switch.
 */
class LED7segDisplay {

public:

   /**
    * Constructor.
    *
    * @param channelA mbed pin for channel A input.
    * @param channelB mbed pin for channel B input.
    */
   LED7segDisplay();

   void Display_6D_write(int32_t); // write to MAX7219 (Main 6-digits display)
   void Display_2D_write(int16_t); // write to MAX7219 (Gate 2-digits display)
   void Display_2D_Blank();
   void Display_brightness_up();
   void Display_brightness_down();
   uint16_t GetBrightness() {return brightness - BRIGHTNESS_MIN;};

private:
   uint16_t brightness;
   uint8_t     Disp_Digit[8]; // used to manage 8-digits through MAX7219
   uint16_t    Stream;        // used to stream out serial data to MAX7219

   void Display_init(void);    // initialize MAX7219
   void sendDataToDisplay(uint16_t data_to_send);
   void Display_brightness(uint16_t brightness);
};

#endif /* LED7segDisplay_H */
