#ifndef HwRegisters_H
#define HwRegisters_H

#include "mbed.h"       // global Mbed library (always needed)

// definitions of the input/outputs (pins)
static DigitalOut  AUX   (D2);    // AUX control for GPS module
static InterruptIn TRIG1 (D3);    // Counter 1 trigger
static InterruptIn TRIG2 (D6);    // Counter 2 trigger
static DigitalIn   QEPB  (D9);    // Quadrature encoder pushbutton
static PwmOut      PWM   (D10);   // PWM output
static DigitalOut  BUZZ  (D13);   // Buzzer

static AnalogIn    AIN0  (A0);    // ADC input 0 (High Voltage)
static AnalogIn    AIN1  (A1);    // ADC input 1 (aux)
static DigitalOut  CS2   (A2);    // 74HC595 RCLK (pin 12)
static DigitalOut  CS1   (A3);    // MAX7219 CS (pin 12)
static DigitalOut  SCK   (A4);    // 74HC595 SRCLK (pin 11) & MAX7219 SCK (pin 13)
static AnalogIn    KEYB  (A5);    // Keyboard input (SW2 & SW3) 
static DigitalOut  MOSI  (A6);    // 74HC595 SER (pin 14) & MAX7219 DIN (pin 1)
static DigitalIn   UN    (A7);    // Unused (in V1 PCB A5 and A7 must be connected)

#endif /* HwRegisters_H */
