#include "mbed.h"
#include "Servo.h"
#include "C12832_lcd.h"

Servo s1(p21);                              //Application board servo is on p21, attach PAN  to header
Servo s2(p22);                              //Application board servo is on p21, attach TILT to header

C12832_LCD lcd;

AnalogIn p1(p19);                           //Left  potentiometer
AnalogIn p2(p20);                           //Right potentiometer

const   int n = 10;                         //number of readings to be averaged, change globally here
float       panT =0, tiltT = 0;             //Total holders for summation from axis arrays

float       PANa, TILTa;                    //averaged values for each axis over n
float       pan[n], tilt[n];                //arrays to hold n readings for each axis
int         i, j;                           //indexing variables

int main()
{
    while(1) {
        for (i = 0; i < n; i = i + 1) {     //read n values into each axis array
            pan[i] = p1.read();
            tilt[i] = p2.read();
        }
        panT = 0;                           //reset Totala
        tiltT = 0;                          //reset Totala
        for (j = 0; j < n; j = j + 1) {     //summation of the contents of each array into axis Totals
            panT = panT+pan[j];
            tiltT = tiltT+tilt[j];
        }
        PANa = panT/n;                      //axis average over n

        TILTa = tiltT/n;                    //axis average over n

        lcd.cls();                          //Clear screen for new cycle
        lcd.locate(30,3);                   //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(43,3);                   //Screen location
        lcd.printf("Pan");                  //Column heading
        lcd.locate(76,3);                   //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(91,3);                   //Screen location
        lcd.printf("Tilt");                 //Column heading
        lcd.locate(3,12);                   //Screen location
        lcd.printf("Norm");                 //column seperator
        lcd.locate(30,12);                  //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(43,12);                  //Screen location
        lcd.printf("%.2f\n",PANa);          //Print PAN
        lcd.locate(76,12);                  //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(91,12);                  //Screen location
        lcd.printf("%.2f\n",TILTa);         //Print TILT
        lcd.locate(3,21);                   //Screen location
        lcd.printf("Angle");                //column seperator
        lcd.locate(30,21);                  //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(43,21);                  //Screen location
        lcd.printf("%.2f\n",PANa*270);      //Print PAN
        lcd.locate(76,21);                  //Screen location
        lcd.printf("|");                    //column seperator
        lcd.locate(91,21);                  //Screen location
        lcd.printf("%.2f\n",TILTa*270);     //Print TILT
        s1=p1;                              //Set PAN servo to PAN potentiometer reading
        s2=p2;                              //Set PAN servo to PAN potentiometer reading
        wait(0.1);                          //Wait for servos to make position
    }
}


