#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include <math.h>

C12832_LCD lcd;
LM75B tmp(p28,p27);

float   temp=0;                             //Initialise temperature
int     i = 0;                              //Initialise counter
int     n = 129;                            //Set LCD screen width

int main ()
{
    lcd.cls();                              //Clear screen
    for (i = 0; i < n; i = i + 1) {         //Move temperature reading across x-axis of the LCD screen
        temp = floor(tmp.read());           //Round down temperature reading
        lcd.locate(i,(32-(temp)));          //Locate reading on LCD screen, 32- inverts position in y-axis
        lcd.printf("%.0f\n",temp);          //Print the value
        wait(.1);                           //Pause
        if (i == (n-10)){                   //Whether the x-axis position on LCD screen reached the maximum value
        i = 0;                              //If so reset x-axis position to 0
        lcd.cls();                          //Clear screen
        }
        else
            ;                               //Otherwise continue the loop
    }
}


