//Iteration for 3 axis, ...
//This code is being developed  for use with
//Sphere and Ring type Physiotherapy Balance Boards
//example images at -
//http://www.balance360.com/servlet/the-Balance-360-Boards/Categories
//The author has no commercial, or other, relationship with [Balance 360] or other manufacturers
//The author is simply having fun
//C B P Chapman

#include "mbed.h"
#include "MMA7660.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
MMA7660 MMA(p28, p27);

DigitalOut connectionLed(LED1);//operation confirmed
DigitalOut servoProxyLed(LED2);//score outcome, proxy for servo

const   int n = 10;                         //number of readings to be averaged, change globally here
float       score = 0;                      //reserved for later
int         angle = 0;                      //reserved for later
float       pulseXT =0, pulseYT = 0;        //Total holders for summation from axis arrays

float       pulseXa, pulseYa;               //averaged values for each axis over n
float       pulseX[n], pulseY[n];           //arrays to hold n readings for each axis
int         i, j;                           //indexing variables

int main()
{

    while(1) {

        for (i = 0; i < n; i = i + 1) {     //read n values into each axis array
            pulseX[i] = MMA.x();
            pulseY[i] = MMA.y();
        }
        pulseXT = 0;                        //reset Totala
        pulseYT = 0;                        //reset Totala
        for (j = 0; j < n; j = j + 1) {     //summation of the contents of each array into axis Totals
            pulseXT = pulseXT+pulseX[j];
            pulseYT = pulseYT+pulseY[j];
        }
        pulseXa = pulseXT/n;                //axis average over n

        pulseYa = pulseYT/n;                //axis average over n

        if (MMA.testConnection())
            connectionLed = 1;

        if (pulseXa > (-0.2) && pulseXa < (0.2) && pulseYa > (-0.2) && pulseYa < (0.2)) {//average result within stability range; x, y
            lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);//first LCD column label
            lcd.printf("x-axis | ");//label column
            lcd.locate(3,12);//xdata location
            lcd.printf("%.2f\n",pulseXa);//print x to LCD
            lcd.locate(40,3);//second LCD column label
            lcd.printf("y-axis | ");//label column
            lcd.locate(40,12);//ydata location
            lcd.printf("%.2f\n",pulseYa);//print y to LCD
            lcd.locate(77,3);//initial LCD location
            lcd.printf("z-axis");//label column
            lcd.locate(77,12);//zdata location
            lcd.printf("%.2f\n",MMA.z());//print z to LCD
            lcd.locate(3,21);//flag location
            lcd.printf("STABLE");//flag
            if (score != 10) {//if score has not reached 10
                ++score;//add 1 to score
                lcd.locate(70,21);//score location
                lcd.printf("SCORE = ");
                lcd.printf("%.0f\n",score);//print score
            } else {
                servoProxyLed = 1;//LED2 HIGH
                lcd.locate(70,21);//notice location
                lcd.printf("NEXT LEVEL");
                wait (10);
                servoProxyLed = 0;//LED@ LOW
                score = 0;//reset score
                
            }
        }

        else {////average result not within stability range; x, y
            lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);//first LCD column label
            lcd.printf("x-axis | ");//label column
            lcd.locate(3,12);//xdata location
            lcd.printf("%.2f\n",pulseXa);//print x to LCD
            lcd.locate(40,3);//second LCD column label
            lcd.printf("y-axis | ");//label column
            lcd.locate(40,12);//ydata location
            lcd.printf("%.2f\n",pulseYa);//print y to LCD
            lcd.locate(77,3);//initial LCD location
            lcd.printf("z-axis");//label column
            lcd.locate(77,12);//zdata location
            lcd.printf("%.2f\n",MMA.z());//print z to LCD
            lcd.locate(3,21);//flag location
            lcd.printf("UNSTABLE");//flag
            score = 0;//reset score
            lcd.locate(70,21);//score location
            lcd.printf("SCORE = ");
            lcd.printf("%.0f\n",score);//print score

        }
    }
}