#include "mbed.h"
Serial pc(USBTX, USBRX);
AnalogIn tempPin1(p15);
AnalogIn tempPin2(p16);
AnalogIn tempPin3(p17);
PwmOut pwm1(p21);
PwmOut pwm2(p22);
float tempTotal1;
float tempTotal2;
float tempTotal3;
uint32_t tempDiv1;
uint32_t tempDiv2;
uint32_t tempDiv3;
#define MAX_TEMP_AVG 10
void sampleTemp();
void sampleTemps();
void resetTempSamples();
float getAvgTemp();
void sampleTemp()
{
        tempTotal1 += tempPin1; 
        tempDiv1++;
        tempTotal2 += tempPin2; 
        tempDiv2++;
        tempTotal3 += tempPin3; 
        tempDiv3++;
       
}
void sampleTemps()
{
    for(int i=0;i<MAX_TEMP_AVG;i++) {
        sampleTemp();
        wait(0.1);
    }
}
void resetTempSamples()
{
    tempTotal1 = 0.0;
    tempDiv1 = 0;
    tempTotal2 = 0.0;
    tempDiv2 = 0;
    tempTotal3 = 0.0;
    tempDiv3 = 0;

}

float getAvgTemp1()
{
    resetTempSamples();
    sampleTemps();
    float tempAvg1 = ((((tempTotal1)*3300/(float)tempDiv1)-400.0)/19.5);
    return tempAvg1;
}
float getAvgTemp2()
{
    resetTempSamples();
    sampleTemps();
    float tempAvg2 = (((((tempTotal2)*3300/(float)tempDiv2)-400.0)/19.5)-1);
    return tempAvg2;
}
float getAvgTemp3()
{
    resetTempSamples();
    sampleTemps();
    float tempAvg3 = (((((tempTotal3)*3300/(float)tempDiv3)-400.0)/19.5));
    return tempAvg3;
}
int main() {
    tempDiv1 = 0;
    tempDiv2 = 0; 
    tempDiv3 = 0;  
    pc.printf("MBED ready..\r\n");
    sampleTemps(); 
    while(1){     
        sampleTemp();                        
        pc.printf("T2=%f          T1=%f           T3=%f\n",getAvgTemp2(),getAvgTemp1(),getAvgTemp3());          // T1,T2,T3
        if(getAvgTemp1()>getAvgTemp2()||getAvgTemp1()>getAvgTemp3()){
        wait_ms(4000);
        }else if(getAvgTemp2()-getAvgTemp1()>0.5||getAvgTemp1()-getAvgTemp3()>0.5){
            for(int i = 0; i <=200; i++){
                pwm1.pulsewidth_us(2000-i*5);
                pwm2.pulsewidth_us(2000-i*5);
                wait_ms(4000);
                }
        }else(getAvgTemp3()>getAvgTemp1()||getAvgTemp1()>getAvgTemp2()){
            for(int i = 0; i <=200 ; i++){
                pwm1.pulsewidth_us(1000+i*5);   //xia max 2000
                pwm2.pulsewidth_us(1000+i*5);   //shang max 2000 
                wait_ms(4000);
                }if(i == 200){                      //xia shang tong shi 2000
             for(int i = 0; i <=200; i++){     
                pwm1.pulsewidth_us(2000+i*5);   //xia 1500+max1000 = 3000
                pwm2.pulsewidth_us(2000-i*5);     //shang 2000-max1000 = 1000
                wait_ms(4000); 
                }     
             }
}
}
}   
