#include "mbed.h"
Serial pc(USBTX, USBRX);
AnalogIn tempPin1(p15);
AnalogIn tempPin2(p16);
PwmOut pwm(p21);
#define start 500;
#define end 2200;
float tempTotal1;
float tempTotal2;
uint32_t tempDiv1;
uint32_t tempDiv2;
#define MAX_TEMP_AVG 10
void sampleTemperature();
void sampleTemperatures();
void resetTemperatureSamples();
void servo();
float getAvgTemperature();
void sampleTemperature()
{
        tempTotal1 += tempPin1; 
        tempDiv1++;
        tempTotal2 += tempPin2; 
        tempDiv2++;
}
void sampleTemperatures()
{
    for(int i=0;i<MAX_TEMP_AVG;i++) {
        sampleTemperature();
        wait(0.1);
    }
}
void resetTemperatureSamples()
{
    tempTotal1 = 0.0;
    tempDiv1 = 0;
    tempTotal2 = 0.0;
    tempDiv2 = 0;
}
void servo()
{
    

}
float getAvgTemperature1()
{
    float tempAvg1 = (((tempTotal1)*3300/(float)tempDiv1)-400.0)/19.5;
    return tempAvg1;
}
float getAvgTemperature2()
{
    float tempAvg2 = (((tempTotal2)*3300/(float)tempDiv2)-400.0)/19.5;
    return tempAvg2;
}


int main() {
    tempDiv1 = 0;
    tempDiv2 = 0;   
    pc.printf("MBED ready..\r\n");
    sampleTemperatures();
    pc.printf("Temp1: %.2f  Temp2: %.2f  \r\n",getAvgTemperature1(),getAvgTemperature2());
    while(1){
        sampleTemperature();       
    }
                
        float j = (getAvgTemperature1()/getAvgTemperature2()) ;
        if(j>0){
        for(int p = start; p < end; p += 20) 
            pwm.pulsewidth_us(p);
            wait_ms(40);
        
        else{
        for(int p = end; p >=start; p -= 20) 
             pwm.pulsewidth_us(p);
            wait_ms(40);
        
        }
    }
}
