#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

DigitalOut led(LED1);
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
AnalogIn tempoknob(A1);
AnalogIn volumeknob(A0);

Serial pc(USBTX, USBRX);
Ticker re,er,rr,ee; //timer ไว้ attach ตอนplay audio กับไว้รับปุ่ม

int checkplay=1,beat[5][8],page=1;
char currentpage[50],tempochar[50],volumechar[50],strvolume[50],strtempo[50]; //สร้างไว้ให้เขียนอักษรได้เฉยๆ
float volume,tempo;
void test(void); //function for touchscreen
void play(void);// function for play
void screen(void);//function for display
void knob(void);// read knob

int main() 
{  
    lcd.Clear(LCD_COLOR_BLUE);
    ee.attach(&screen, 0.03);
    re.attach(&play, 0.1);//เล่นตามsamplerate
    er.attach(&test, 0.25);//กดช้ากดเร็วแล้วแต่
    rr.attach(&knob,0.5);//readknob ทุก0.5
}

void play() 
{
      if(checkplay==1)//led blink when button play is on
      {
      led=!led;
      }
      else if(checkplay==0)//led off
            {
                led=0;
            }
   
}
void test() 
{
       TS_StateTypeDef TS_State;
       uint8_t status;//ไม่ได้ใช้สร้างไว้ก่อน
       ts.GetState(&TS_State);  
       if((TS_State.touchDetected))//รับtouchอะไรก็ตาม จะเข้าfunctionนี้
       {
        
        if(TS_State.touchX[0]<74&&TS_State.touchX[0]>24&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//playbutton
        {
            if(checkplay==0)  
            {
            checkplay=1;
            }  
            else if(checkplay==1)
            {
                checkplay=0;
            }
        }
        if(TS_State.touchX[0]<74&&TS_State.touchX[0]>24&&TS_State.touchY[0]<161&&TS_State.touchY[0]>136)//previous page
        {
            page=page-1;
            if(page<1) 
            {
            page=5;
            }  
            pc.printf("change to page %d",page);
            
        }
         if(TS_State.touchX[0]<431&&TS_State.touchX[0]>406&&TS_State.touchY[0]<161&&TS_State.touchY[0]>136)//next page
        {
            page=page+1;
            if(page>5) 
            {
            page=1;
            }  
            pc.printf("change to page %d",page);
            
        }
          if(TS_State.touchX[0]<122&&TS_State.touchX[0]>98&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat1
        {
            if(beat[page-1][0]==0) 
            {
            beat[page-1][0]=1;
            }  
            else if(beat[page-1][0]==1)
            {
                beat[page-1][0]=0;
            }
        }
          if(TS_State.touchX[0]<166&&TS_State.touchX[0]>142&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat2
        {
            if(beat[page-1][1]==0) 
            {
            beat[page-1][1]=1;
            }  
            else if(beat[page-1][1]==1)
            {
                beat[page-1][1]=0;
            }

        }          
          if(TS_State.touchX[0]<210&&TS_State.touchX[0]>186&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat3
        {
            if(beat[page-1][2]==0) 
            {
            beat[page-1][2]=1;
            }  
            else if(beat[page-1][2]==1)
            {
                beat[page-1][2]=0;
            }

        }
          if(TS_State.touchX[0]<254&&TS_State.touchX[0]>230&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat4
        {
            if(beat[page-1][3]==0) 
            {
            beat[page-1][3]=1;
            }  
            else if(beat[page-1][3]==1)
            {
                beat[page-1][3]=0;
            }

        }
          if(TS_State.touchX[0]<298&&TS_State.touchX[0]>274&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat5
        {
            if(beat[page-1][4]==0) 
            {
            beat[page-1][4]=1;
            }  
            else if(beat[page-1][4]==1)
            {
                beat[page-1][4]=0;
            }

        }
          if(TS_State.touchX[0]<342&&TS_State.touchX[0]>318&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat6
        {
            if(beat[page-1][5]==0) 
            {
            beat[page-1][5]=1;
            }  
            else if(beat[page-1][5]==1)
            {
                beat[page-1][5]=0;
            }

        }
          if(TS_State.touchX[0]<386&&TS_State.touchX[0]>362&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat7
        {
            if(beat[page-1][6]==0) 
            {
            beat[page-1][6]=1;
            }  
            else if(beat[page-1][6]==1)
            {
                beat[page-1][6]=0;
            }

        }
          if(TS_State.touchX[0]<430&&TS_State.touchX[0]>406&&TS_State.touchY[0]<248&&TS_State.touchY[0]>198)//beat8
        {
            if(beat[page-1][7]==0) 
            {
            beat[page-1][7]=1;
            }  
            else if(beat[page-1][7]==1)
            {
                beat[page-1][7]=0;
            }

        }

        pc.printf("at page :%d    ",page); //ไว้check uart เฉยๆ
        pc.printf("%d",beat[page-1][0]);
        pc.printf("%d",beat[page-1][1]);
        pc.printf("%d",beat[page-1][2]);
        pc.printf("%d",beat[page-1][3]);
        pc.printf("%d",beat[page-1][4]);
        pc.printf("%d",beat[page-1][5]);
        pc.printf("%d",beat[page-1][6]);
        pc.printf("%d",beat[page-1][7]);
        pc.printf("\n\r");
        }
 }
 
 void knob()//read analog
{
 
  volume=(volumeknob.read()*100);//0to100
   tempo=(tempoknob.read()*100);//problematic********************************************
  
  sprintf(tempochar,"%1.1f",tempo);  
  sprintf(volumechar,"%1.1f",volume);  
  pc.printf("tempo =  %s \n\r",tempochar);  //print ในuart ถูก
  pc.printf("volume =  %s\n\r",volumechar);  
    
}
 
 
 
 
 void screen()// function for display
{
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_BROWN);//play button
    lcd.FillRect(24,198,50,50);
    lcd.SetTextColor(LCD_COLOR_YELLOW);//previous page
    lcd.FillRect(24,136,50,25);
    lcd.SetTextColor(LCD_COLOR_YELLOW);// next page
    lcd.FillRect(406,136,50,25);
    
    sprintf(strvolume,"%s","Volume "); //display volume
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(24,LINE(1),(uint8_t*)strvolume,LEFT_MODE);
    sprintf(volumechar,"%s",volumechar);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(24,LINE(2),(uint8_t*)volumechar,LEFT_MODE);
    
    sprintf(strtempo,"%s","Tempo ");
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(24,LINE(1),(uint8_t*)strtempo,RIGHT_MODE);
    sprintf(tempochar,"%s",tempochar); ////////////////////////////////////////////display tempo on lcd ไม่ถูก
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(24,LINE(2),(uint8_t*)tempochar,RIGHT_MODE);
    
    
   
    
       if(page==1) //พวกนี้คือแสดงหน้าว่าอยู่หน้าอะไร
        {
        sprintf(currentpage,"%s","Current page is Drum1");
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(24,LINE(3),(uint8_t*)currentpage,LEFT_MODE);
        }
        else if(page==2)
        {
        sprintf(currentpage,"%s","Current page is Drum2");
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(24,LINE(3),(uint8_t*)currentpage,LEFT_MODE);   
        }
       else if(page==3)
        {
        sprintf(currentpage,"%s","Current page is Drum3");
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(24,LINE(3),(uint8_t*)currentpage,LEFT_MODE);   
        }
       else if(page==4)
        {
        sprintf(currentpage,"%s","Current page is Drum4");
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(24,LINE(3),(uint8_t*)currentpage,LEFT_MODE);   
        }
       else if(page==5)
        {
        sprintf(currentpage,"%s","Current page is Drum5");
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(24,LINE(3),(uint8_t*)currentpage,LEFT_MODE);   
        }
            
           // พวกนี้คือเปลี่ยนปุ่มแต่ละ beat
            if(beat[page-1][0]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(98,198,24,50);
            }
            if(beat[page-1][0]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(98,198,24,50);
            }
            if(beat[page-1][1]==0)            
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(142,198,24,50);
            }
            if(beat[page-1][1]==1)            
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(142,198,24,50);
            }
            if(beat[page-1][2]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(186,198,24,50);
            }
            if(beat[page-1][2]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(186,198,24,50);
            }
            if(beat[page-1][3]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(230,198,24,50);
            }
            if(beat[page-1][3]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(230,198,24,50);
            }
            if(beat[page-1][4]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(274,198,24,50);
            }
            if(beat[page-1][4]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(274,198,24,50);
            }
            if(beat[page-1][5]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(318,198,24,50);
            }
            if(beat[page-1][5]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(318,198,24,50);
            }
            if(beat[page-1][6]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(362,198,24,50);
            }
            if(beat[page-1][6]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(362,198,24,50);
            }
            if(beat[page-1][7]==0)
            {
             lcd.SetTextColor(LCD_COLOR_LIGHTRED);
             lcd.FillRect(406,198,24,50);    
            }
            if(beat[page-1][7]==1)
            {
             lcd.SetTextColor(LCD_COLOR_GREEN);
             lcd.FillRect(406,198,24,50);    
            }

  }
    