//It is the code of the GPRS communication by the use of the Sim800 module.
//This code has work is "to upload data on data.sparkfun.com in every 5 seconds.
//To check the uploaded data the URL is "data.sparkfun.com/streams/roYVdJgWrXUpxVpDYJpA".

#include "mbed.h"
#include <string> 

Serial sim800(PTE0,PTE1);                                   //Serial communication of the sim800 and pc.
Serial pc(USBTX,USBRX);

AnalogIn pot(PTB0);
AnalogIn ldr(PTB1);

char x[300],y[30],z[30],l[30],m[30];
            
int main()
{
    float potval = 0;
    float ldrval = 0;

    pc.baud(9600);
    sim800.baud(9600);

    pc.printf("*******GPRS TEST*******\r\n");

    sim800.printf("ATE0\r\n");                              //Command for the TURN OFF the repated terms(ECHO).
        sim800.scanf("%s",x);                               //Take response in string x given by the "sim800".
        pc.printf("%s\r\n",x);
       
        sim800.printf("AT+CGATT?\r\n");                     //To check the GPRS is attached or not.
            sim800.scanf("%s%s",x,y);
            pc.printf("%s   %s\r\n",x,y);
        
        sim800.printf("AT+CIPSHUT\r\n");                    //To reset the IP session if any.
            sim800.scanf("%s%s",x,y);
            pc.printf("%s   %s\r\n",x,y);
  
        sim800.printf("AT+SAPBR=3,1,Contype,GPRS\r\n");     //To Set the connection type to GPRS.
            sim800.scanf("%s",x);
            pc.printf("%s\r\n",x);
        
        sim800.printf("AT+SAPBR=3,1,APN,www\r\n");          //To Set the APN to to "www" , It might be different for you, and depends on the network.
            sim800.scanf("%s",x);
            pc.printf("%s\r\n",x);
        
        sim800.printf("AT+SAPBR =1,1\r\n");                 //To Enable the GPRS.
            sim800.scanf("%s",x);
            pc.printf("%s\r\n",x);
        
        sim800.printf("AT+SAPBR =2,1\r\n");                 //To get the IP address.
            sim800.scanf("%s%s%s",x,y,z);
            pc.printf("%s   %s  %s\r\n",x,y,z); 
        
        
        sim800.printf("AT+HTTPINIT\r\n");                   //To enable the HTTP mode.
            sim800.scanf("%s",x);
            pc.printf("%s\r\n",x);
        
        sim800.printf("AT+HTTPPARA=CID,1\r\n");             //To sets up HTTP parameters for the HTTP call.
            sim800.scanf("%s",x);
            pc.printf("%s\r\n",x);
            
        
        float lng,lat = 0;
        while(lat == 0)
        {                            
            sim800.printf("AT+CIPGSMLOC=1,1\r\n");          //To check the Location of GSM in Co-Ordinates(Longitude,Latitude).
            sim800.scanf("%s%s%s",x,y,z);
            sscanf(y,"0,%f,%f",&lng,&lat);                  //To sperate out the value of longitude and latitude from the string 'y'.       
        }
        pc.printf("%0.6f   %0.6f",lng,lat);
        
        
        while(1)
        {
            potval = pot.read();
            ldrval = ldr.read();
        
            sim800.printf("AT+HTTPPARA=URL,data.sparkfun.com/input/roYVdJgWrXUpxVpDYJpA?private_key=jkgpNMYr81cgMGgbypgr&co_lat=%0.6f&co_long=%0.6f&ldr=%0.2f&pot=%0.2f\r\n",lat,lng,potval,ldrval);
                                                            //The above command is for "To Set the url to the address of the webpage you want to access".
                sim800.scanf("%s",x);
                pc.printf("%s\r\n",x);
            
            sim800.printf("AT+HTTPACTION=0\r\n");           //To Start the HTTP GET session, by giving this command.
                sim800.scanf("%s%s%s",x,y,z);
                pc.printf("%s   %s  %s\r\n",x,y,z);
        
            sim800.printf("AT+HTTPREAD\r\n");               //To read the received data.
                sim800.scanf("%s%s%s%s%s",x,y,z,l,m);
                pc.printf("%s   %s  %s  %s  %s\r\n",x,y,z,l,m);
            
            wait(5);
        }
}