#include "mbed.h"
#include <cstdlib>                                      //librairie pour convertir char en float                (libraby that convert char into float)
#include <string>

Serial tel(D8, D2);                                     //module bluetooth HC-05 branché à D8 (TX) et D2 (RX)   (Bluetooth Hc05, Tx is link to D8 pin and Rx to D2)
DigitalOut moteur(D5);                                  //broche du moteur                                      (Engine to D5 pin)
DigitalIn bouton(PC_13);                                //broche du bouton                                      (if you want to use a button condition, it's PC_13 pin)
PwmOut pwm(D11);                                        //broche de la PWM                                      (PWM is on D11 pin)


int main()
{
    float puissance;
    while(1) {
        if(tel.readable()) {                            //Si on peut utiliser le bluetooth                      (if Bluetooth is readable)
            tel.baud(9600);                             //FrameRate du bluetooth                                (Bluetooth framerate)
            puissance = tel.getc();                     //récupère l'info en char                               (save as char what the bluetooth module got)
            printf("puissance: %f \n",puissance);       //test                                                  (just a test to know the power between 1 and 255)
            pwm.write(puissance/255);                   //Info du bluetooth en char que l'on applique a la pwm  (dividing power by 255 in order to have a pwm ratio)
            moteur=1;                                   //On lance le moteur                                    (starting engine)
        }
    }
}
