// N.C. testing n-bed with LCD

#include "mbed.h"
#include "TextLCD.h"

//n-bed CONNECTOR "L" JP6
TextLCD  lcd(p17,   p20,   p24, p23,   p22,   p8,    TextLCD::LCD20x4); // rs, e, d4-d7

//n-bed CONNECTOR "K" JP7
//Drive LCD from NON mbed pins
TextLCD lcd2(P1_19, P1_22, p15, P1_25, P1_26, P1_27, TextLCD::LCD20x4); // rs, e, d4-d7

Timer t;
DigitalOut led1(LED1);

//Measure from a NON mbed analog pin 
AnalogIn input(P0_2); //the range of the analog input goes, from 0 V. to 3.3V.  the actual value is represented as a float from 0 to 1.
float ain; //ain must be a float, for matching the input.read type.
AnalogIn input2(P0_3); //the range of the analog input goes, from 0 V. to 3.3V.  the actual value is represented as a float from 0 to 1.
float ain2; //ain must be a float, for matching the input.read type.

int main() {
    t.start();
    lcd.cls();
    wait(1);
    lcd.printf("n-bed 1st Display\n"); lcd2.printf("n-bed 2nd Display\n");
    while (1) {
        led1 = 1;
        ain=input.read();
        
        time_t seconds = time(NULL);
        lcd.locate(0,1); lcd2.locate(0,1);
        lcd.printf("%s", ctime(&seconds));  lcd2.printf("%s", ctime(&seconds));
            
        lcd.locate(0,2); lcd2.locate(0,2);
        lcd.printf("n-bed A3=%1.1f V", ( float(3.3)*ain) )  ;  lcd2.printf("n-bed A3=%1.1f V", ( float(3.3)*ain) )  ;
        wait(0.001);
        ain2=input2.read();
        lcd.locate(0,3); lcd2.locate(0,3);
        lcd.printf("n-bed A4=%1.1f V", ( float(3.3)*ain2) )  ;  lcd2.printf("n-bed A4=%1.1f V", ( float(3.3)*ain2) )  ;
        led1 = 0;
        wait(0.9);
    }
}




