#include "USBHostMSD.h"
#include "USBHostC270.h"

Serial pc(USBTX, USBRX);
BusOut leds(LED1, LED2, LED3);

int main() {
    pc.baud(921600);

    USBHostMSD* msd = new USBHostMSD("usb"); // USB flash drive
    USBHostC270* cam = new USBHostC270(C270_MJPEG, C270_160x120, _1FPS); // Logitech C270

    uint8_t buf[1024*3];
    Timer interval_t;
    interval_t.reset();
    interval_t.start();
    int shot = 0;
    while(1) {
        if (interval_t.read() > 10 && cam->connected()) {
            int r = cam->readJPEG(buf, sizeof(buf));
            char path[32];
            snprintf(path, sizeof(path), "/usb/image%02d.jpg", shot % 20);
            printf("%d %s %d bytes\n", shot, path, r);
            if (msd->connected()) {
                printf("msd connected\n");
                FILE* fp = fopen(path, "wb");
                if (fp) {
                    fwrite(buf, r, 1, fp);
                    fclose(fp);
                }
                shot++;
                leds = shot % 8;
            }
            else {
                printf("msd NOT connected\n");
                }
            interval_t.reset();
        }
        if (!msd->connected()) {
            msd->connect();
            Thread::wait(500);
        }
        if (!cam->connected()) {
            cam->connect();
            Thread::wait(500);
        } else {
            cam->poll();
        }
    }
}
