 // 2011.05.05 NX
 // This a test of [Andrew L] mbos
 // main.c copied from  mbos.h comments
 // ** A 3d task added **
 
 
 //* A typical simple example with two tasks, and one timer, might look like this:
 //* @code
 // mbos Blinky demonstration.
 // Task 1 toggles LED1 every second, under control of a timer. It then posts an event to
 // task 2 which flashed LED2 briefly.
  #include "mbed.h"                    
  #include "mbos.h"
 
  #define TASK1_ID                1       // Id for task 1 (idle task is 0)
  #define TASK1_PRIO              50      // priority for task 1
  #define TASK1_STACK_SZ          32      // stack size for task 1 in words 
  
  #define TASK2_ID                2       // Id for task 2 
  #define TASK2_PRIO              60      // priority for task 2
  #define TASK2_STACK_SZ          32      // stack size for task 2 in words 
  
  #define TASK3_ID                3       // Id for task 3 
  #define TASK3_PRIO              70      // priority for task 3
  #define TASK3_STACK_SZ          32      // stack size for task 2 in words 
  
  #define TIMER0_ID               0       // Id for timer 0
  #define TIMER0_PERIOD           1000    // Time period in milliseconds
  #define TIMER0_EVENT            1       // Event flag (1 << 0)
  
  #define T1_TO_T2_EVENT          2       // Event flag (1 << 1)
  #define T2_TO_T3_EVENT          2       // Event flag (1 << 1)
 
  void task1(void);                       // task function prototypes
  void task2(void);
  void task3(void);

  DigitalOut led1(LED1);
  DigitalOut led2(LED2);
  DigitalOut led3(LED3);
  mbos os(3, 1);                          // Instantiate mbos with 3 tasks & 1 timer    
 
  int main(void)
  {
      // Configure tasks and timers
      os.CreateTask(TASK1_ID, TASK1_PRIO, TASK1_STACK_SZ, task1);
      os.CreateTask(TASK2_ID, TASK2_PRIO, TASK2_STACK_SZ, task2);
      
      os.CreateTask(TASK3_ID, TASK3_PRIO, TASK3_STACK_SZ, task3);
      
      os.CreateTimer(TIMER0_ID, TIMER0_EVENT, TASK1_ID);
      // Start mbos
      os.Start();
      // never  return!
  }
 
  void task1(void)
  {
      os.SetTimer(TIMER0_ID, TIMER0_PERIOD, TIMER0_PERIOD);
      while(1){
          os.WaitEvent(TIMER0_EVENT);
          led1 = !led1;
          os.SetEvent(T1_TO_T2_EVENT, TASK2_ID);
      }
  }
 
  void task2(void)
  {
      while(1){
          os.WaitEvent(T1_TO_T2_EVENT);
          led2 = 1;
          wait_ms(100);
          led2 = 0;
          os.SetEvent(T2_TO_T3_EVENT, TASK3_ID);
      }
  }

  void task3(void)
  {
      while(1){
          os.WaitEvent(T2_TO_T3_EVENT);
          led3 = 1;
          wait_ms(100);
          led3 = 0;
      }
  }
