// N.C. Freertos mbed minimal example based on below:
// https://developer.mbed.org/users/rgrover1/code/FreeRTOS/
// http://www.radekdostal.com/content/freertos-610-minimal-example
// 20/04/2017 update: Compiled for  and NUCLEO-F104RB, without errors
// Complile without errors: LPC1768,NUCLEO-F104RB,F401RE,L152RE
// Compilation Errors for: EA LPC11U35, TG-LPC11U35-501 nRF51822, FRDM-K25Z,
//                         nRF52-DK,BBC micro:bit,LPC1114FN28, NUCLEO-F030R8
//                         NUCLEO-F746ZG, LPC800-MAX



// Nikos 07/09/2019: Is using Cortex M3 version FreeRTOS, confirmed to to be compiled with cotexM3 CPUs
// LPC1768, L152, F401, F103, Teensy3.1

#include "mbed.h"
#include "FreeRTOS.h"
#include "task.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

void Task1 (void* pvParameters)
{       
    (void) pvParameters;                    // Just to stop compiler warnings.   
    for (;;) {
        led1 = !led1;
        printf("Task1\n");
        vTaskDelay(500);
    }
}

void Task2 (void* pvParameters)
{
    (void) pvParameters;                    // Just to stop compiler warnings.
    for (;;) {
        led2= !led2;
        printf("Task2\n");
        vTaskDelay(5000);
    }
}

int main (void)
{
    xTaskCreate( Task1, ( signed char * ) "Task1", configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY, ( xTaskHandle * ) NULL );
    xTaskCreate( Task2, ( signed char * ) "Task2", configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY, ( xTaskHandle * ) NULL );
    vTaskStartScheduler();
   //should never get here
   printf("ERORR: vTaskStartScheduler returned!");
   for (;;);
}