
void P_PL_INIT();
void P_PL_MAIN();
void P_COM_INIT();
void P_CDMS_HK_MAIN();
void P_PL_RCV_SC_DATA();
void P_CDMS_INIT_SD();
void CDMS_SD_SW_ON();
void CDMS_SD_SW_OFF();
void SW_ON_BAE();
void SW_OFF_BAE();
void SW_ON_PL_BEE();
void SW_OFF_PL_BEE();
void SW_ON_PL_EPS();
void SW_OFF_PL_EPS();
void SW_ON_V_A_EN();
void SW_OFF_V_A_EN();
void RST_SD();
void RST_BAE();
void RST_PL_BEE();
void RST_HK_COUNTER();
uint8_t CDMS_RD_SD_HK(uint8_t *);
void CDMS_INTERNAL_RESET();

void P_PL_INIT()
{
    
}

void P_PL_MAIN()
{
    
}

void P_COM_INIT()
{
    
}

void P_CDMS_HK_MAIN()
{
    //FCTN_CDMS_HK_MAIN();
}

void P_PL_RCV_SC_DATA()
{

}

void P_CDMS_INIT_SD()
{
    FCTN_CDMS_SD_INIT();
}

void CDMS_SD_SW_ON()
{
    SD_SW_EN_DS = 0; //powering on SD
}

void CDMS_SD_SW_OFF()
{
    SD_SW_EN_DS = 0; //powering on SD
}

void SW_ON_BAE()
{
    BAE_SW_EN_DS = 0; //Power ON BAE
}

void SW_OFF_BAE()
{
    BAE_SW_EN_DS = 1; //Switch OFF BAE
}

void SW_ON_PL_BEE()
{
    PL_SW_EN_DS = 0; //Power ON PL
}

void SW_OFF_PL_BEE()
{
      PL_SW_EN_DS = 1;  // switching OFF PL    
}

void SW_ON_PL_EPS()
{
    
}

void SW_OFF_PL_EPS()
{

}

void SW_ON_V_A_EN()
{
    
}

void SW_OFF_V_A_EN()
{

}

void RST_SD()
{
    SD_SW_EN_DS = 1; //switching off SD card
    wait_ms(10);
    SD_SW_EN_DS = 0;
    FCTN_CDMS_SD_INIT();
}

void RST_BAE()
{
    BAE_SW_EN_DS = 1; //Switch OFF BAE
    wait_ms(10);
    BAE_SW_EN_DS = 0; //Switch ON BAE
}

void RST_PL_BEE()
{
    PL_SW_EN_DS = 1;  // switching OFF PL
    wait_ms(10);
    PL_SW_EN_DS = 0;  // Switch ON PL
}

void RST_HK_COUNTER()
{
    firstCount = true;
}

uint8_t CDMS_RD_SD_HK(uint8_t *sd_statusbits)
{
    uint8_t p;
    uint8_t ACK;
    if(SD_SW_EN_DS != DEVICE_POWERED)
    {
        ACK = 0x89;
        SD_RD_ERROR = 1;
        //Generate TM
    }
    else
    {
        p = disk_read_statusbits(sd_statusbits);
        if(p == 0)
            ACK = 0xA0;
        else
            ACK = 0x89;
    }
    return ACK;
}

void CDMS_INTERNAL_RESET()
{
    
}